<?php
/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         ddi  la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a t dvelopp initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu sous licence GNU/GPL.         *
 *  Pour plus de dtails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/


include_spip('inc/actions');
include_spip('inc/editer');

//
// Fonction CVT
//

function formulaires_editer_lieu_charger($id_document='new')
{

	$valeurs = array();
	if($id_document) {
		$r = sql_fetsel("fichier, titre, descriptif","spip_documents","id_document=".intval($id_document));
		if($r) {
			$valeurs = $r;
			$valeurs['fichier'] = _DIR_IMG .$valeurs['fichier'];
		}
	}
	return $valeurs;
	
}

function formulaires_editer_lieu_verifier($id_document='new')
{
	$erreurs = array();	
	return $erreurs;
}

function formulaires_editer_lieu_traiter($id_document='new')
{

	$resultat = array();
	
	// On rcupre l'objet GeoJSON
	$lieu_geo = json_decode(_request('dumpy'));
	
	// On ajoute les proprits issues du formulaire ...
	$lieu_geo->properties->titre = _request('titre');
	$lieu_geo->properties->id_auteur = _request('id_auteur');
	$lieu_geo->properties->descriptif = _request('descriptif');
	
	// On construit la bounding box
	$polygon = $lieu_geo->geometry->coordinates[0];
	$minlng = 180; $maxlng=-180;
	$minlat=90; $maxlat =-90;
	foreach($polygon as $vertex) {
		$minlng = ($minlng > $vertex[0]) ? $vertex[0] : $minlng;
		$minlat = ($minlat > $vertex[1]) ? $vertex[1] : $minlat;
		$maxlng = ($maxlng < $vertex[0]) ? $vertex[0] : $maxlng;
		$maxlat = ($maxlat < $vertex[1]) ? $vertex[1] : $maxlat;
	}
	$lieu_geo->bbox = array($minlng, $minlat, $maxlng, $maxlat);
	
	// on gnre le fichier
	$repertoire = _DIR_TMP;
	$nom_envoye = $lieu_geo->properties->titre . '.lieu';
	$file = tempnam($repertoire, "lieu_");

	$fp = fopen($file,"w");
	if($fp) {
		// ecrire le fichier
		fwrite($fp,json_encode($lieu_geo));
		fclose($fp);
		$iddoc = 0;
		$download = array(
			'name' => $nom_envoye,
			'tmp_name' => $file,
			'type' => 'text/plain',
			'size' => filesize($file),
			'error' => UPLOAD_ERR_OK
			);		
		// Dclarer le document dans la base
		include_spip('action/ajouter_documents');
		$ajouter_un_document = charger_fonction('ajouter_un_document', 'action');
		$iddoc = $ajouter_un_document($id_document,$download,'','','document');
		
		if ($iddoc) {
			    $autdata = sql_fetsel(array('nom'),'spip_auteurs',"id_auteur=".intval(session_get('id_auteur')));
				sql_updateq('spip_documents',
					array(
						'credits' => $autdata['nom'],
						'titre' => _request('titre')
						),
					"id_document=".intval($iddoc)
					);
			$resultat['message_ok'] = _T('biodiv:nouveau_lieu',array('docid'=> $iddoc)) . ' : ' . $lieu_geo->properties->titre;
		} else {
			$resultat['message_erreur'] = _T('biodiv:echec_creation_lieu') . $lieu_geo->properties->titre;
		}
		
	} else {
		$resultat['message_erreur'] = _T('biodiv:echec_creation_tmp', array('fich' => $lieu_geo->properties->titre));
	}

	// On retourne le rsultat
	spip_unlink($file);
	
	return $resultat;
}

?>
