<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         dédié à la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2023 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a été développé initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.         *
 *  Pour plus de détails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

 
 function repAmpUrl($url) {
   return 'href="' . preg_replace('/&/','&#38;',$url[1]) . '"';
   }
   
 function cleanUrlForXml($texte) {
   return preg_replace_callback('|href="([^"]*)"|','repAmpUrl',$texte);
 }
 
/**
 * Filtre pour transformer une entité HTML en entité XML
 * Utilisation pour la génération XML d'un article
 * Syntaxe : [(#TEXTE|en_xml)]
 *
 * @param string $str - texte original
 * @return string - texte transformé
**/
 
function en_xml($str)
{
    // Filtrage des URL dans le texte
    $str=cleanUrlForXml($str);
    
    // Filtrage des entités
    //$xml = array('&#34;','&#38; ','&#38;','&#60;','&#62;','&#160;','&#161;','&#162;','&#163;','&#164;','&#165;','&#166;','&#167;','&#168;','&#169;','&#170;','&#171;','&#172;','&#173;','&#174;','&#175;','&#176;','&#177;','&#178;','&#179;','&#180;','&#181;','&#182;','&#183;','&#184;','&#185;','&#186;','&#187;','&#188;','&#189;','&#190;','&#191;','&#192;','&#193;','&#194;','&#195;','&#196;','&#197;','&#198;','&#199;','&#200;','&#201;','&#202;','&#203;','&#204;','&#205;','&#206;','&#207;','&#208;','&#209;','&#210;','&#211;','&#212;','&#213;','&#214;','&#215;','&#216;','&#217;','&#218;','&#219;','&#220;','&#221;','&#222;','&#223;','&#224;','&#225;','&#226;','&#227;','&#228;','&#229;','&#230;','&#231;','&#232;','&#233;','&#234;','&#235;','&#236;','&#237;','&#238;','&#239;','&#240;','&#241;','&#242;','&#243;','&#244;','&#245;','&#246;','&#247;','&#248;','&#249;','&#250;','&#251;','&#252;','&#253;','&#254;','&#255;');
    //$html = array('&quot;','& ','&amp;','&lt;','&gt;','&nbsp;','&iexcl;','&cent;','&pound;','&curren;','&yen;','&brvbar;','&sect;','&uml;','&copy;','&ordf;','&laquo;','&not;','&shy;','&reg;','&macr;','&deg;','&plusmn;','&sup2;','&sup3;','&acute;','&micro;','&para;','&middot;','&cedil;','&sup1;','&ordm;','&raquo;','&frac14;','&frac12;','&frac34;','&iquest;','&Agrave;','&Aacute;','&Acirc;','&Atilde;','&Auml;','&Aring;','&AElig;','&Ccedil;','&Egrave;','&Eacute;','&Ecirc;','&Euml;','&Igrave;','&Iacute;','&Icirc;','&Iuml;','&ETH;','&Ntilde;','&Ograve;','&Oacute;','&Ocirc;','&Otilde;','&Ouml;','&times;','&Oslash;','&Ugrave;','&Uacute;','&Ucirc;','&Uuml;','&Yacute;','&THORN;','&szlig;','&agrave;','&aacute;','&acirc;','&atilde;','&auml;','&aring;','&aelig;','&ccedil;','&egrave;','&eacute;','&ecirc;','&euml;','&igrave;','&iacute;','&icirc;','&iuml;','&eth;','&ntilde;','&ograve;','&oacute;','&ocirc;','&otilde;','&ouml;','&divide;','&oslash;','&ugrave;','&uacute;','&ucirc;','&uuml;','&yacute;','&thorn;','&yuml;');
    $xml = array('&#34;','&#38; ','&#38;','&#60;','&#62;','&#160;','&#161;','&#162;','&#163;','&#164;','&#165;','&#166;','&#167;','&#168;','&#169;','&#170;','&#171;','&#172;','&#173;','&#174;','&#175;','&#176;','&#177;','&#178;','&#179;','&#180;','&#181;','&#182;','&#183;','&#184;','&#185;','&#186;','&#187;','&#188;','&#189;','&#190;','&#191;','&#192;','&#193;','&#194;','&#195;','&#196;','&#197;','&#198;','&#199;','&#200;','&#201;','&#202;','&#203;','&#204;','&#205;','&#206;','&#207;','&#208;','&#209;','&#210;','&#211;','&#212;','&#213;','&#214;','&#215;','&#216;','&#217;','&#218;','&#219;','&#220;','&#221;','&#222;','&#223;','&#224;','&#225;','&#226;','&#227;','&#228;','&#229;','&#230;','&#231;','&#232;','&#233;','&#234;','&#235;','&#236;','&#237;','&#238;','&#239;','&#240;','&#241;','&#242;','&#243;','&#244;','&#245;','&#246;','&#247;','&#248;','&#249;','&#250;','&#251;','&#252;','&#253;','&#254;','&#255;','&#151;','&#151;','&#151;','&#151;');
    $html = array('&quot;','& ','&amp;','&lt;','&gt;','&nbsp;','&iexcl;','&cent;','&pound;','&curren;','&yen;','&brvbar;','&sect;','&uml;','&copy;','&ordf;','&laquo;','&not;','&shy;','&reg;','&macr;','&deg;','&plusmn;','&sup2;','&sup3;','&acute;','&micro;','&para;','&middot;','&cedil;','&sup1;','&ordm;','&raquo;','&frac14;','&frac12;','&frac34;','&iquest;','&Agrave;','&Aacute;','&Acirc;','&Atilde;','&Auml;','&Aring;','&AElig;','&Ccedil;','&Egrave;','&Eacute;','&Ecirc;','&Euml;','&Igrave;','&Iacute;','&Icirc;','&Iuml;','&ETH;','&Ntilde;','&Ograve;','&Oacute;','&Ocirc;','&Otilde;','&Ouml;','&times;','&Oslash;','&Ugrave;','&Uacute;','&Ucirc;','&Uuml;','&Yacute;','&THORN;','&szlig;','&agrave;','&aacute;','&acirc;','&atilde;','&auml;','&aring;','&aelig;','&ccedil;','&egrave;','&eacute;','&ecirc;','&euml;','&igrave;','&iacute;','&icirc;','&iuml;','&eth;','&ntilde;','&ograve;','&oacute;','&ocirc;','&otilde;','&ouml;','&divide;','&oslash;','&ugrave;','&uacute;','&ucirc;','&uuml;','&yacute;','&thorn;','&yuml;','&mdash;','&ndash;','&dash;','&hyphen;');
    $str = str_replace($html,$xml,$str);
    if(function_exists('str_ireplace')) $str = str_ireplace($html,$xml,$str);
    return $str;
} 

function no8217($str) {
	$str = str_replace('&#8217;',"'",$str);	
	return($str);
}

function numeric_entities($string){
    $mapping = array();
    foreach (get_html_translation_table(HTML_ENTITIES, ENT_QUOTES) as $char => $entity){
        $mapping[$entity] = '&#' . ord($char) . ';';
    }
    return str_replace(array_keys($mapping), $mapping, $string);
}
 
/** 
 * Spoiler
 * Remplace la balise <spoiler></spoiler> par une division et un effet javascript
 * afin d'afficher ou de masquer alternativement le contenu entre les balises.
 *
 * @param string texte $letexte	- texte contenant poentiellement une zone <spoiler>
 * @return string	- texte transformé
 *
**/

function spoiler ($letexte) {
	$letexte = preg_replace("/<spoiler>/", "<div class='plusmoinsparent' onClick=\"this.nextSibling.style.display=((this.nextSibling.style.display=='none')?'':'none');\"><a href='javascript:;' class='plusmoins'>Lire plus/moins</a></div><div style='display:none;'><br/>", $letexte);
	$letexte = preg_replace("/<\/spoiler>/", "</div>", $letexte);
	return $letexte;
}

/**
 *Recherche des forums impactant un auteur
 * Retourne les messages ayant moins de trente jours
 *
 * @param int $id_auteur
 * @return array
**/

function forums_a_suivre($id_auteur) {
    $delai = 2592000; /* secondes dans 30 jours */
	$before = time() - $delai;
	$bdata = getdate($before);
	$dmax = sprintf("%04d-%02d-%02d %02d:%02d:%02d",
		$bdata["year"],$bdata["mon"],$bdata["mday"],
		$bdata["hours"],$bdata["minutes"],$bdata["seconds"]);
	// spip_log("BIODIV::Forums $id_auteur: ".$dmax,"biodiv."._LOG_INFO_IMPORTANTE);
	
	$res = sql_select(
		array( // select
			"o.id_observation AS id_observation",
			"o.titre AS titre_observation",
			"f.id_forum AS id_forum",
			"f.titre AS titre_forum",
			"f.date_heure AS date_forum",
			"f.auteur AS auteur_forum",
			),
		array( // from
			"spip_biodiv_observations AS o",
			"spip_forum AS f",
			"spip_auteurs_liens AS al"
			),
		array( // where
			"o.id_observation = f.id_objet",
			"f.objet = 'observation'",
			"f.date_heure > ".sql_quote($dmax),
			"al.objet = 'observation'",
			"al.id_objet = o.id_observation",
			"al.id_auteur = ".intval($id_auteur),
			"f.id_auteur != ".intval($id_auteur)
			),
		"", // group by
		"f.date_heure DESC"	// order by
		);
	
	$retour = array();
	if ($res) {
		while ($r = sql_fetch($res)) {
			$retour[] = $r;  // utilisation des resultats avec $r['colonne']
		}
	}
	return $retour;
}



?>
