<?xml version="1.0" encoding="iso-8859-1"?>

<!--
  Document   : lieupdf.xsl
  Version    : 0.1
  Created on : 10 Fvrier 2015
  Author     : renaud.laurette
  Comment    : 
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
		version="1.0">

  <!-- Type de sortie -->
  <xsl:output method="xml" version="1.0" encoding="UTF-8"/>
  
  <!-- Parametres d'appel -->
  <xsl:param name="id_groupe" />
  
  <!-- Variables globales -->
  <xsl:variable name="context" select="/context"/>
  <xsl:variable name="source">
    <xsl:value-of select="$context/server"/>
    <xsl:text>ws.php?page=especes&amp;id_rubrique=</xsl:text>
    <xsl:value-of select="$id_groupe"/>
  </xsl:variable>
  <xsl:variable name="groupe" select="document($source)"/>
  <xsl:variable name="cfBandeau">
    <xsl:value-of select="$context/server"/>
    <xsl:text>ws/img/bandeau.svg</xsl:text>
  </xsl:variable>
      
  <!-- STRUCTURE du DOCUMENT -->
  
  <xsl:template match="/">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
      <xsl:call-template name="master-layout" />
      <fo:page-sequence master-reference="my-sequence">
        <!-- zones statiques -->
        <xsl:call-template name="headers" />
        <xsl:call-template name="footers" />
        <!-- Zone dynamique -->  
        <fo:flow flow-name="xsl-region-body">
        	 <fo:block 
        	 	text-align="center" text-indent="0cm"
        	 	font-family="Times" font-size="24pt" color="blue"
        	 	padding-top="25pt" padding-bottom="25pt" span="all"
        	 	 >
        	    <xsl:value-of select="$groupe/groupe/titre"/>
        	  </fo:block>
        	  <xsl:apply-templates select="$groupe/groupe/espece" />

        </fo:flow>
     <!-- Fin des pages -->
     </fo:page-sequence>
    <!-- Fin du document -->
    </fo:root>
  </xsl:template>

  
  
 <!--
 	Dfinitions gnrales de layout PDF
  -->
  
  <xsl:template name="master-layout">
      <fo:layout-master-set>
      <!-- Premiere page -->
      <fo:simple-page-master master-name="first-page" page-height="29.7cm" page-width="21cm"
                             margin-top="1cm" margin-bottom="1cm" margin-left="1.5cm" margin-right="1.5cm">
           <fo:region-body    column-count="3" margin-left="0cm" margin-top="3.5cm" margin-bottom="4cm"/>
           <fo:region-before region-name="my-header-one" extent="3.5cm"
                             precedence="true" display-align="after"  />
           <fo:region-after  region-name="my-footer-one" extent="4cm" precedence="true" margin-top="0cm" />
      </fo:simple-page-master>

      <fo:simple-page-master master-name="all-pages" page-height="29.7cm" page-width="21cm"
                             margin-top="1cm" margin-bottom="1cm" margin-left="1.5cm" margin-right="1.5cm">
           <fo:region-body   column-count="3" margin-left="0cm" margin-top="2.1cm" margin-bottom="1.5cm"/>
           <fo:region-before region-name="my-header-two" extent="1.8cm"
                             precedence="true" display-align="after" />
           <fo:region-after  region-name="my-footer-two" extent="1cm"
                             precedence="true" display-align="after" />
      </fo:simple-page-master>
      
      
      <!-- Definition de la sequence -->
      <fo:page-sequence-master master-name="my-sequence">
        <fo:single-page-master-reference master-reference="first-page"/>
        <fo:repeatable-page-master-reference master-reference="all-pages"/>
      </fo:page-sequence-master>
    </fo:layout-master-set>	
  </xsl:template>

  
  <!--
        Zones Statiques
        ===============
    -->
    
   <xsl:template name="headers">
   
      <!-- 
      	Header de la page #1 
      -->
     <fo:static-content flow-name="my-header-one">
       <!-- logo -->
       <fo:block-container
                        height="2.8cm" width="3.2cm"
                        top="0cm" left="0cm" position="absolute"
                        margin="0pt">
            <fo:block>
            	<fo:external-graphic  width="100%" content-width="scale-to-fit" content-height="2.8cm">
            	  <xsl:attribute name="src">
            	    <xsl:value-of select="$groupe//org/logo"/>
            	  </xsl:attribute>
            	</fo:external-graphic>
            </fo:block>
       </fo:block-container>
       
       <!-- bandeau color -->
       <fo:block-container height="0.5cm" width="18cm"
       			top="3cm" left="0cm" position="absolute" margin="0pt">
       	 <fo:block>
       	         <fo:external-graphic  width="100%" content-width="scale-to-fit" content-height="1cm">
            	  <xsl:attribute name="src">
            	    <xsl:value-of select="$cfBandeau"/>
            	  </xsl:attribute>
            	</fo:external-graphic>
       	 </fo:block>                                                                     
       </fo:block-container>
       
       <!-- signature organisme -->
       <fo:block-container height="2.2cm" width="14.5cm" top="0.5cm" left="3.5cm" position="absolute" margin="3pt">
       		<fo:block text-align="start" font-family="Times" font-size="12pt" font-weight="bold" color="black">
       			<xsl:value-of select="$groupe/groupe/org/nom"/>
       		</fo:block>
       		<fo:block text-align="start" font-family="Times" font-size="12pt" color="black">
       			<xsl:value-of select="$groupe/groupe/org/description"/>
       		</fo:block>
       		<fo:block text-align="start" font-family="Times" font-size="12pt" color="black">
       			<xsl:value-of select="$groupe/groupe/org/adresse"/>
       		</fo:block>
       		<fo:block text-align="start" font-family="Courier" font-size="10pt" color="black"
                 	padding-before="3pt" padding-after="6pt">
                 	<xsl:value-of select="$groupe/groupe/org/site"/> - <xsl:value-of select="$groupe/groupe/org/email"/>
                 </fo:block>
       </fo:block-container>
     </fo:static-content>
 
     <!--  
     	header des autres pages 
     -->
     <fo:static-content flow-name="my-header-two">
     	<fo:block
             border-bottom-color="blue"
             border-bottom-style="solid"
             border-bottom-width="thin"
             padding-after="4pt"
             font-family="Times" font-size="12pt" font-style="italic"
             color="darkblue">
           <xsl:value-of select="$groupe/groupe/titre"/>
         </fo:block>
     </fo:static-content>
     
  </xsl:template>
  
     
  <xsl:template name="footers">
  
  	<!-- Zones statiques : footer  -->
  	<fo:static-content flow-name="my-footer-one">
  		<fo:block-container
                       height="3.5cm" width="18cm" top="0.5cm" left="0cm" position="absolute"
                       border-top-color="blue"  border-top-style="solid" border-top-width="thin"
                       margin="3pt" padding-top="5pt" font-style="italic"
                       >
                     <xsl:apply-templates select="$groupe//org/memo">
                       <xsl:with-param name="fontSize" select="'10pt'"/>
                     </xsl:apply-templates>
                </fo:block-container>
        </fo:static-content>
        
        <!-- zones statiques : footer autres pages -->
        <fo:static-content flow-name="my-footer-two">
        	<fo:block
        		padding-before="6pt" 
        		border-top-color="blue" border-top-style="solid" border-top-width="thin"
        		font-family="Times" font-size="12pt" font-style="italic"
        		text-align="center"
        		color="darkblue">
        	   <xsl:value-of select="$groupe/groupe/@site"/>
        	   <xsl:text> - Extrait le </xsl:text>
        	   <xsl:value-of select="$groupe/groupe/@date"/>
        	   <xsl:text> - Page </xsl:text>
        	   <fo:page-number/>
        	 </fo:block>
        </fo:static-content>
        
   </xsl:template> 
  
  
  <xsl:template match="espece">
     <fo:block
     	margin="4pt" padding="4pt"
        border-color="blue" border-style="solid" border-width="thin"
        font-family="Times" font-size="10pt"
        text-align="center" page-break-inside="avoid"
        >
        <xsl:value-of select="titre"/>
        <fo:block font-style="italic">
          <xsl:value-of select="titre/@latin"/>
        </fo:block>
        <xsl:apply-templates select="img[@titre='logo']"/>
     </fo:block>
  </xsl:template>
 
  
  <!--
  	Traitement des lments de texte
  -->
  
  <xsl:template match="img">
    <fo:block padding="5pt">
      <fo:external-graphic src="{@src}" 
      	content-width="scale-to-fit" 
      	content-height="100%" 
      	width="100%" scaling="uniform"/>
    </fo:block>
  </xsl:template>
  <!--
  <xsl:template match="img">
    <fo:block space-after="6pt">
      <fo:external-graphic src="{@src}" height="auto"/>
    </fo:block>
  </xsl:template>
  -->		
  <xsl:template match="p[@class='citation']">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>

    <fo:block text-align="justify" text-indent="0cm"
              font-family="{$fontFamily}" font-size="{$fontSize}" font-style="italic"
              space-before="3pt" space-after="4pt" color="brown"
              margin-left="0.5cm" margin-right="0.5cm"
              >
     <xsl:apply-templates/>
    </fo:block>
  </xsl:template>
                    	
  <xsl:template match="p">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    
    <fo:block text-align="justify" text-indent="0cm"
              font-family="{$fontFamily}" font-size="{$fontSize}"
              space-before="3pt" space-after="4pt" 
              >
     <xsl:apply-templates/>
    </fo:block>
  </xsl:template>

  <xsl:template match="h2">
    <fo:block   text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="14pt"
                space-before="12pt" space-after="6pt"
                background-color="lightblue">
      <xsl:value-of select="."/>
    </fo:block>
  </xsl:template>

  <xsl:template match="h3">
    <fo:block   text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="12pt"
                space-before="6pt" space-after="4pt"
                color="blue">
      <xsl:value-of select="."/>
    </fo:block>
  </xsl:template>
  

  <xsl:template match="h4">
    <fo:block   text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="11pt"
                space-before="4pt" space-after="4pt"
                >
      <xsl:value-of select="."/>
    </fo:block>
  </xsl:template>
  
  <xsl:template match="hr">
    <fo:block>
      <fo:leader leader-length="100%" leader-pattern="rule" rule-thickness="1pt" color="black"/>
    </fo:block>
  </xsl:template>
  <!--
  <xsl:template match="br">
    <fo:block break-before="line"/>
  </xsl:template>  
  -->
  <xsl:template match="li">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    
    <fo:list-item>
      <fo:list-item-label end-indent="label-end()">
        <fo:block>&#x2022;</fo:block>
      </fo:list-item-label>
      <fo:list-item-body start-indent="body-start()">
        <fo:block font-family="{$fontFamily}" font-size="{$fontSize}"><xsl:apply-templates/></fo:block>
      </fo:list-item-body>
    </fo:list-item>
  </xsl:template>
  
  <xsl:template match="ul">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    
    <fo:list-block
                   provisional-distance-between-starts="14pt"
                   provisional-label-separation="3pt"
                   text-align="justify"
                   font-family="{$fontFamily}" font-size="{$fontSize}"
                   space-before="3pt" space-after="4pt">
    <xsl:apply-templates select="li"/>
    </fo:list-block>
  </xsl:template>

  
  <xsl:template match="b|strong">
    <fo:inline font-weight="bold"><xsl:apply-templates/></fo:inline>
  </xsl:template>
  
  <xsl:template match="i">
    <fo:inline font-style="italic"><xsl:apply-templates/></fo:inline>
  </xsl:template>

  <xsl:template match="u">
    <fo:inline text-decoration="underline"><xsl:apply-templates/></fo:inline>
  </xsl:template>
  
  <xsl:template match="a[@href]">
    <fo:basic-link external-destination="url({@href})"
                   text-decoration="underline" color="blue"><xsl:apply-templates/></fo:basic-link>
  </xsl:template>

  <xsl:template match="text()">
    <xsl:value-of select="."/>
  </xsl:template>
  
 </xsl:stylesheet>
