# BIODIV
**Copyright (C) 2008-2024 Renaud LAURETTE**   

Ce fichier LICENCE-BIODIV.md remplace le fichier BIODIVSRC.txt utilisé
précédemment.

## Licence

Ce programme est un logiciel libre distribué sous licence **GNU/GPL**.
Vous pouvez le redistribuer et/ou le modifier sous les conditions décrites
par la licence GNU/GPL version 3 de la Free Software Foundation.

Ce programme est distribué dans l'espoir qu'il sera utile, mais 
SANS AUCUNE GARANTIE ; sans même une garantie implicite de COMMERCIABILITE 
ou DE CONFORMITE A UNE UTILISATION PARTICULIERE. Voir la Licence Publique 
Générale GNU pour plus de détails. Vous devriez avoir reçu un exemplaire 
de la [Licence Publique Générale GNU](http://gnugpl.org/) avec ce programme ; 
si ce n'est pas le cas, consultez http://gnugpl.org/

## Qu'est-ce que BIODIV ?

**BIODIV** est à la fois une extension (un plugin) et un ensemble de squelettes de 
mise en page pour le système [SPIP](https://www.spip.net) de gestion de contenus.
Son fonctionnement s'appuie sur SPIP et sur quelques uns de ses plugins, disponibles
sur le site [SPIP Contrib](https://contrib.spip.net).

**BIODIV** est dédié aux associations naturalistes qui cherchent à collecter, organiser
et partager des observations dans un mode participatif. Il a été initialement développé pour
l'Association de Protection du Cadre de Vie et de l'Environnement Balmanais [APCVEB](https://apcveb.fr),
afin de sensibiliser les habitants de Balma à la biodiversité locale.
  
Le premier site contributif mis en service est [Biodiv.Balma](https://balma.biodiv.fr),
géré à Balma, en région toulousaine, par l'[APCVEB](https://apcveb.fr).

Ce logiciel permet notamment de :
* créer des observations et les illustrer par des photos ou des enregistrements sonores
* saisir des observations directement sur le terrain depuis un téléphone portable
* organiser les observations par espèces afin de constituer un inventaire
* afficher des répartitions dans le temps et dans l'espace
* définir des périmètres géographiques pour permettre un suivi spécifique
* organiser des campagnes ciblées dans le temps et l'espace
* effectuer des recherches multi-critères sur la base d'observation, éditer des rapports
* référencer les espèces observées selon les standards du Muséum National d'Histoire Naturelle 
* exporter les observations dans différents formats dont celui du Muséum National d'Histoire Naturelle
* importer des observations d'organismes partenaires
* importer des informations à partir de traceurs GPS
* etc ...

## Documentation et mises à jour

Ses fonctionnalités et les dernières mises à jour sont disponibles sur le site
du projet: [Projet.Biodiv](http://projet.biodiv.balgor.fr).

## Composants

**BIODIV** s'appuie sur les composants suivants :
* [SPIP](https://www.spip.net) - Système de publication pour l'internet 
* Divers plugins de SPIP, disponibles sur [SPIP Contrib](https://contrib.spip.net) : 
    * acces_restreint : controle d'accès à certaines rubriques
    * agenda : pour la gestion des sorties et manifestations
    * breves : gestion des brèves
    * calendrier_mini : en complément du plugin 'Agenda'
    * compositions : gestion des variations de mises en pages
    * http : Interface CRUD pour la création d'API
    * menus : gestion de menus personnalisés
    * nospam : protection des formulaires contre les robots spammeurs
    * pages : gestion de pages uniques hors des rubriques
    * roles : typage des liaisons entre objets
    * roles_documents : typage des liaisons avec les documents
    * saisies : aide à la saisie de formulaires
    * socialtags : partage sur les réseaux sociaux
    * spip-bonux : des extensions diverses
    * squelettes_par_rubrique : comme son nom l'indique
    * verifier : controle de type lors des saisies	
    * yaml : support du format yaml
* Des plugins SPIP spécifiques aux sites Biodiv disponibles sur [Projet.Biodiv](http://projet.biodiv.balgor.fr)
	* biodiv : la gestion des objets spécifiques à biodiv, utilisant :
		* [exif-js](https://github.com/exif-js/exif-js) pour l'analyse des balises EXIF dans les images
		* [pdfmake](https://pdfmake.github.io/docs/0.1/) pour la génération de PDF côté navigateur
	* biows : API JSON pour biodiv
	* feuillet : gestion de la cartographie, sur la base de la bibliothèque [leaflet](https://leafletjs.com) et des plugins leaflet suivants :
		* [leaflet-draw](http://leaflet.github.io/Leaflet.draw/) pour dessiner sur les cartes
		* [leaflet-omnivore](https://github.com/steveathon/leaflet-omnivore) pour le support de différents formats géométriques
		* [leaflet-fullscreen](https://github.com/brunob/leaflet.fullscreen) pour l'affichage plein écran
	* hasherfin : une variante du plugin hasher pour optimiser le stockage des fichiers
	* rebond : pour accéder à des vidéos et sons non locaux au site
	* sibmail : Pour interagir avec le CRM Brevo (ex Sendinblue)
	* sibactu : pour préparer des lettres d'actualité à difuser via sibmail
* Des éléments de mise en page et de présentation
	* [inuit-css](https://github.com/inuitcss) et [eve-styles.css](https://sg-layout.com) pour les feuilles de style
	* [fontawesome](https://fontawesome.com) pour quelques icones


    