<?php
/**
 * Utilisation de l'action supprimer pour l'objet campagne
 *
 * @plugin     Biodiv
 * @copyright  2020
 * @author     Renaud LAURETTE
 * @licence    GNU/GPL
 * @package    SPIP\Biodiv\Action
 */

if (!defined('_ECRIRE_INC_VERSION')) {
	return;
}



/**
 * Action pour supprimer un·e campagne
 *
 * Vérifier l'autorisation avant d'appeler l'action.
 *
 * @example
 *     ```
 *     [(#AUTORISER{supprimer, campagne, #ID_CAMPAGNE}|oui)
 *         [(#BOUTON_ACTION{<:campagne:supprimer_campagne:>,
 *             #URL_ACTION_AUTEUR{supprimer_campagne, #ID_CAMPAGNE, #URL_ECRIRE{biodiv_campagnes}},
 *             danger, <:campagne:confirmer_supprimer_campagne:>})]
 *     ]
 *     ```
 *
 * @example
 *     ```
 *     [(#AUTORISER{supprimer, campagne, #ID_CAMPAGNE}|oui)
 *         [(#BOUTON_ACTION{
 *             [(#CHEMIN_IMAGE{campagne-del-24.png}|balise_img{<:campagne:supprimer_campagne:>}|concat{' ',#VAL{<:campagne:supprimer_campagne:>}|wrap{<b>}}|trim)],
 *             #URL_ACTION_AUTEUR{supprimer_campagne, #ID_CAMPAGNE, #URL_ECRIRE{biodiv_campagnes}},
 *             icone s24 horizontale danger campagne-del-24, <:campagne:confirmer_supprimer_campagne:>})]
 *     ]
 *     ```
 *
 * @example
 *     ```
 *     if (autoriser('supprimer', 'campagne', $id_campagne)) {
 *          $supprimer_campagne = charger_fonction('supprimer_campagne', 'action');
 *          $supprimer_campagne($id_campagne);
 *     }
 *     ```
 *
 * @param null|int $arg
 *     Identifiant à supprimer.
 *     En absence de id utilise l'argument de l'action sécurisée.
**/
function action_supprimer_campagne_dist($arg=null) {
	if (is_null($arg)){
		$securiser_action = charger_fonction('securiser_action', 'inc');
		$arg = $securiser_action();
	}
	$arg = intval($arg);

	// cas suppression
	if ($arg) {
		sql_delete('spip_biodiv_campagnes',  'id_campagne=' . sql_quote($arg));
	}
	else {
		spip_log("action_supprimer_campagne_dist $arg pas compris");
	}
}
