<?php
/**
 * Déclarations relatives à la base de données
 *
 * @plugin     Biodiv
 * @copyright  2024
 * @author     Renaud LAURETTE
 * @licence    GNU/GPL
 * @package    SPIP\Biodiv\Pipelines
 */

if (!defined('_ECRIRE_INC_VERSION')) {
	return;
}


/**
 * Déclaration des alias de tables et filtres automatiques de champs
 *
 * @pipeline declarer_tables_interfaces
 * @param array $interfaces
 *     Déclarations d'interface pour le compilateur
 * @return array
 *     Déclarations d'interface pour le compilateur
 */
function biodiv_declarer_tables_interfaces($interfaces) {

	$interfaces['table_des_tables']['biodiv_observations'] = 'biodiv_observations';
	$interfaces['table_des_tables']['biodiv_sources'] = 'biodiv_sources';
	$interfaces['table_des_tables']['taxrefs'] = 'taxrefs';
	$interfaces['table_des_tables']['biodiv_campagnes'] = 'biodiv_campagnes';

	return $interfaces;
}


/**
 * Déclaration des objets éditoriaux
 *
 * @pipeline declarer_tables_objets_sql
 * @param array $tables
 *     Description des tables
 * @return array
 *     Description complétée des tables
 */
function biodiv_declarer_tables_objets_sql($tables) {

	$tables['spip_biodiv_observations'] = array(
		'type' => 'observation',
		'principale' => 'oui',
		'table_objet_surnoms' => array('biodivobservation'),
		'field'=> array(
			'id_observation'     => 'bigint(21) NOT NULL',
			'titre'              => 'text NOT NULL',
			'creation'           => 'timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP',
			'type_obs'           => 'enum("espece","autre") NOT NULL default "espece"',
			'espece'             => 'text NOT NULL',
			'id_espece'          => 'bigint(21) NOT NULL default 0',
			'id_famille'         => 'bigint(21) NOT NULL default 0',
			'id_source'          => 'bigint(21) NOT NULL default 1',
			'ref_source'         => 'text',
			'id_sujet'           => 'bigint(21) NOT NULL default 0',
			'quantite'           => 'int(11) NOT NULL DEFAULT 1',
			'denombrement'       => 'enum("Co","Es","Ca","NSP") NOT NULL DEFAULT "Co"',
			'date_obs'           => 'date NOT NULL',
			'pjour'              => 'enum("lever du soleil","matin","apres-midi","coucher du soleil","nuit") NOT NULL DEFAULT "matin"',
			'descriptif'         => 'text NOT NULL',
			'adresse'            => 'text NOT NULL',
			'commune'            => 'varchar(80) NOT NULL DEFAULT "inconnue"',
			'insee'              => 'varchar(10) NOT NULL DEFAULT "00000"',
			'lat'                => 'decimal(10,6) NOT NULL DEFAULT "43.609895"',
			'lng'                => 'decimal(10,6) NOT NULL DEFAULT "1.497567"',
			'discret'            => 'enum("oui","non","inconnu") NOT NULL DEFAULT "inconnu"',
			'date'               => 'datetime NOT NULL DEFAULT "0000-00-00 00:00:00"',
			'maj'                => 'TIMESTAMP'
		),
		'key' => array(
			'PRIMARY KEY'        => 'id_observation',
		),
		'titre' => 'titre AS titre, "" AS lang',
		'date' => 'date',
		'champs_editables'  => array('titre', 'type_obs', 'espece', 'quantite', 'denombrement', 'date_obs', 'pjour', 'descriptif', 'adresse', 'commune', 'insee', 'lat', 'lng', 'discret'),
		'champs_versionnes' => array(),
		'rechercher_champs' => array("titre" => 3, "espece" => 3, "descriptif" => 3, "adresse" => 1, "commune" => 1),
		'tables_jointures'  => array('spip_biodiv_observations_liens')
	);

	$tables['spip_biodiv_sources'] = array(
		'type' => 'source',
		'principale' => 'oui',
		'table_objet_surnoms' => array('biodivsource'), // table_objet('source') => 'biodiv_sources' 
		'field'=> array(
			'id_source'          => 'bigint(21) NOT NULL',
			'titre'              => 'text NOT NULL',
			'creation'           => 'timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP',
			'descriptif'         => 'text NOT NULL',
			'acces'              => 'text',
			'identifiant'        => 'text',
			'publication'        => 'date NOT NULL',
			'editeur'            => 'text',
			'support'            => 'text',
			'createur'           => 'text',
			'statut_source'      => 'enum("Te","Co","Li","NSP") NOT NULL DEFAULT "NSP"',
			'maj'                => 'TIMESTAMP'
		),
		'key' => array(
			'PRIMARY KEY'        => 'id_source',
		),
		'titre' => 'titre AS titre, "" AS lang',
		 #'date' => '',
		'champs_editables'  => array('titre', 'descriptif', 'acces', 'identifiant', 'publication', 'editeur', 'createur', 'statut_source'),
		'champs_versionnes' => array(),
		'rechercher_champs' => array("titre" => 3, "descriptif" => 3, "editeur" => 3, "createur" => 3),
		'tables_jointures'  => array(),


	);

	$tables['spip_taxrefs'] = array(
		'type' => 'taxref',
		'principale' => 'oui',
		'field'=> array(
			'id_taxref'          => 'bigint(21) NOT NULL', 				// cd_nom
			'cd_ref'             => 'bigint(21) NOT NULL DEFAULT "0"',
			'nom'          	     => 'varchar(80) NOT NULL',
			'id_espece'          => 'bigint(21) NOT NULL DEFAULT "0"',
			'regne'              => 'varchar(40) NOT NULL DEFAULT "inconnu"',
			'group1'             => 'varchar(40) NOT NULL default "inconnu"',
			'group2'             => 'varchar(40) NOT NULL default "inconnu"',
			'rang'               => 'varchar(8) NOT NULL default "ES"',
			'sensible'           => 'enum("oui","non","inconnu") NOT NULL DEFAULT "non"',
			'creation'           => 'timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP',
			'maj'                => 'TIMESTAMP'
		),
		'key' => array(
			'PRIMARY KEY'        => 'id_taxref',
		),
		'titre' => 'nom AS titre, "" AS lang',
		 #'date' => '',
		'champs_editables'  => array('id_taxref', 'cd_ref', 'nom', 'id_espece', 'regne', 'group1', 'group2', 'rang', 'sensible'),
		'champs_versionnes' => array(),
		'rechercher_champs' => array("nom" => 3, "regne" => 3, "group1" => 3, "group2" => 3),
		'tables_jointures'  => array(),


	);	
		
	$tables['spip_biodiv_campagnes'] = array(
		'type' => 'campagne',
		'principale' => 'oui',
		'table_objet_surnoms' => array('biodivcampagne'),  
		'field'=> array(
			'id_campagne'        => 'bigint(21) NOT NULL',
			'id_rubrique'        => 'bigint(21) NOT NULL DEFAULT 0',
			'id_secteur'         => 'bigint(21) NOT NULL DEFAULT 0',
			'titre'              => 'text NOT NULL DEFAULT ""',
			'texte'              => 'longtext NOT NULL DEFAULT ""',
			'debut'              => 'date NOT NULL DEFAULT "0000-00-00"',
			'fin'                => 'date NOT NULL DEFAULT "0000-00-00"',
			'statut'             => 'varchar(20)  DEFAULT "0" NOT NULL',
			'maj'                => 'TIMESTAMP'
		),
		'key' => array(
			'PRIMARY KEY'        => 'id_campagne',
			'KEY id_rubrique'    => 'id_rubrique',
			'KEY id_secteur'     => 'id_secteur',
			'KEY statut'         => 'statut',
		),
		'titre' => 'titre AS titre, "" AS lang',
		 #'date' => '',
		'champs_editables'  => array('titre', 'texte', 'debut', 'fin', 'id_rubrique', 'id_secteur'),
		'champs_versionnes' => array('id_rubrique', 'id_secteur'),
		'rechercher_champs' => array("titre" => 3, "texte" => 3, "debut" => 1, "fin" => 1),
		'tables_jointures'  => array(),
		'statut_textes_instituer' => array(
			'prepa'    => 'texte_statut_en_cours_redaction',
			'prop'     => 'texte_statut_propose_evaluation',
			'publie'   => 'texte_statut_publie',
			'refuse'   => 'texte_statut_refuse',
			'poubelle' => 'texte_statut_poubelle',
		),
		'statut'=> array(
			array(
				'champ'     => 'statut',
				'publie'    => 'publie',
				'previsu'   => 'publie,prop,prepa',
				'post_date' => 'date',
				'exception' => array('statut','tout')
			)
		),
		'texte_changer_statut' => 'campagne:texte_changer_statut_campagne',


	);

	return $tables;
}


/**
 * Déclaration des tables secondaires (liaisons)
 *
 * @pipeline declarer_tables_auxiliaires
 * @param array $tables
 *     Description des tables
 * @return array
 *     Description complétée des tables
 */
function biodiv_declarer_tables_auxiliaires($tables) {

	$tables['spip_biodiv_observations_liens'] = array(
		'field' => array(
			'id_observation'     => 'bigint(21) DEFAULT "0" NOT NULL',
			'id_objet'           => 'bigint(21) DEFAULT "0" NOT NULL',
			'objet'              => 'VARCHAR(25) DEFAULT "" NOT NULL',
			'vu'                 => 'VARCHAR(6) DEFAULT "non" NOT NULL',
		),
		'key' => array(
			'PRIMARY KEY'        => 'id_observation,id_objet,objet',
			'KEY id_observation' => 'id_observation',
		)
	);
	
	return $tables;
}
