<?php
/**
 * Fichier gérant la montée en version du plugin Biodiv vers la version 3.0
 * Passage de Spip 2.1 à Spip 3.2
 * Remplacement des articles de composition=campagne par des objets campagne
 * Remplacement d'un auteur unique d'observation à des auteurs multiples
 *
 * @plugin     Biodiv
 * @copyright  2020
 * @author     Renaud LAURETTE
 * @licence    GNU/GPL
 * @package    SPIP\Biodiv\Installation
 */

if (!defined('_ECRIRE_INC_VERSION')) {
	return;
}

include_spip('action/editer_objet');

function m30_auteur_observation($entree) {
	return array(
		'id_auteur' => $entree['id_auteur'],
        'id_objet' => $entree['id_observation'],
        'objet' => 'observation'
        );
} 


function biodiv_migration_3_0 () {
	// Récuperer le prefixe des tables
	// On suppose que les anciennes tables ont le même préfixe
	$prefixe = $GLOBALS['connexions'][0]['prefixe'];
	
	// Créer des campagnes en remplacement des articles de type campagne
	$mapping = array();
	$cs = sql_allfetsel('*','spip_articles',array("composition='campagne'", "statut='publie'"));
	spip_log("MIG.3.0 - Migration des campagnes : n=". count($cs), "biodiv."._LOG_INFO_IMPORTANTE);
	foreach($cs as $artcamp) {
		$aid = $artcamp['id_article'];
		$rid = $artcamp['id_rubrique'];
		$champs = array(
			'titre' => $artcamp['titre'],
			'texte' => $artcamp['texte'],
			'debut' => '1999-01-01',
			'fin' => '2099-01-01'
			);
		$cid = objet_inserer('campagne',$rid,$champs);
		$mapping[$aid] = $cid;
		objet_instituer('campagne',$cid,array('statut'=>'publie'));
	}
	
	// Retrouver les documents liés à la campagne
	$articles = sql_in('id_objet',array_keys($mapping));
	$ds= sql_allfetsel(
			array('id_document','objet','id_objet'),
			'spip_documents_liens',
			array("objet='article'",$articles)
			);
	spip_log("MIG.3.0 - Migration des liens document/campagne : n=". count($ds), "biodiv."._LOG_INFO_IMPORTANTE);
	foreach($ds as $lien) {
		$a = $lien['id_objet'];
		$d = $lien['id_document'];
		sql_insertq('spip_documents_liens',array(
				'id_document' => $d,
				'objet' => 'campagne',
				'id_objet' => $mapping[$a]
				));
		sql_delete('spip_documents_liens',array(
				'id_document='.intval($d),
				'id_objet='.intval($a),
				"objet='article'"
				));
	}
	
	// Retrouver les observations liées à la campagne
	// La table spip_observations_liens n'existe plus en 3.0. Il faut donc la nommer explicitement.
	$tobsliens = $prefixe . '_observations_liens';
	$os = sql_allfetsel(array('id_observation','objet','id_objet','relation'),$tobsliens,array("objet='article'","relation='campagne'",$articles));		
	spip_log("MIG.3.0 - Migration des liens observation/campagne : n=". count($os), "biodiv."._LOG_INFO_IMPORTANTE);
	foreach($os as $lien) {
		$a = $lien['id_objet'];
		$o = $lien['id_observation'];
		sql_insertq('spip_biodiv_observations_liens',array(
				'id_observation' => $o,
				'objet' => 'campagne',
				'id_objet' => $mapping[$a]
				));
		// sql_delete($tobsliens,$lien);
	}
	
	// Mettre les anciennes campagnes à la poubelle
	foreach($mapping as $a => $c) {
		objet_instituer('article',$a,array('statut'=>'poubelle'));
	}	
	
	// Lier les auteurs aux observations
	$xo = sql_getfetsel('MAX(id_observation)','spip_biodiv_observations');
	spip_log("MIG.3.0 - Migration des auteurs d'observations (max=$xo)","biodiv."._LOG_INFO_IMPORTANTE);
	// On partitionne les mises à jour pour ne pas saturer la mémoire
	$step= 300; $total=0;
	for($i=1; $i <= $xo; $i += $step) {
		$max = $i + $step; $min = $i -1;
		$sel = sql_select(
				array('id_observation','id_auteur'),
				'spip_biodiv_observations',
				array("id_observation > $min", "id_observation < $max")
				);
		$resultats = sql_fetch_all($sel);
		if($n=count($resultats)) {
			sql_insertq_multi('spip_auteurs_liens',array_map('m30_auteur_observation',$resultats));
			spip_log("MIG.3.0 - Iteration $i ($min,$max) : $n observations","biodiv."._LOG_INFO_IMPORTANTE);
			$total += $n;
		}
	}
	spip_log("MIG.3.0 - Auteurs : total de $total observations","biodiv."._LOG_INFO_IMPORTANTE);
}
	