<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         dédié à la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a été développé initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.         *
 *  Pour plus de détails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

// biodiv:inc/jws_connect.php

/*
 * Vérification de la validité d'un token d'autentification
 * Retourne un tableau avec un champ statut :
 * 		id_auteur : quand le token existe et est valide
 *		-id_auteur: quand le token existe mais a expiré
 *		0: quand le token n'existe pas.
 */
 
function jws_controle_token($key=null) {
  // Recherche de l'auteur corespondant au token
  $row = sql_fetsel('*','spip_auteurs','cookie_oubli LIKE '.sql_quote('b.'. $key . '%'));
  if($row) {
  	//spip_log("JWS::ControlToken - $key is found","jws."._LOG_INFO_IMPORTANTE);
  	// Un enregistrement correspond: on décode les données
  	list($prefix,$clef,$limite) = explode('.',$row['cookie_oubli']);
  	// On vérifie si le token n'a pas expiré
  	$t = time();
  	if($t < $limite) {
  		//spip_log("JWS::ControlToken - token is still valid","jws."._LOG_INFO_IMPORTANTE);
    	$reponse = array(
        	"status" => intval((string)$row['id_auteur']),
        	"observateur" => $row['nom'],
        	"session" => $key 	// le token servira de clé de session
        	); 	
        // $reponse['limite']=$limite;
        // $reponse['timestamp']=$t;
    } else { 
    	//spip_log("JWS::ControlToken - token has expired","jws."._LOG_INFO_IMPORTANTE);
    	$reponse = array("status" => (-1) * intval($row['id_auteur'])); 
    }
  } else { 
  	// spip_log("JWS::ControlToken - token NOT VALID","jws."._LOG_INFO_IMPORTANTE);
  	$reponse = array("status" => 0); 
  }
  $clean = jws_nettoie_tokens();
  //$reponse['nettoyage']=$clean;

  return $reponse;
}

/*
 * Supprime tous les tokens expirés
 */

function jws_nettoie_tokens() {
	// les tokens commencent tous par 'b.' pour les distinguer des vrais 'cookie_oubli'
	$rows = sql_select(array('id_auteur','cookie_oubli'),'spip_auteurs','cookie_oubli LIKE '.sql_quote('b.%'));
	$t = time(); $clean=array();
	while($row = sql_fetch($rows)) { 
		list($prefix,$clef,$limite) = explode('.',$row['cookie_oubli']);
		if($t > intval($limite)) {
			sql_updateq('spip_auteurs',array('cookie_oubli' => ''),'id_auteur='.$row['id_auteur']);
			$clean[]=array(
				"auteur" => $row['id_auteur'],
				"cookie" => $row['cookie_oubli'],
				"timestamp" => $t,
				"limite" => $limite
				);
		}
	}
	return $clean;
}

function jws_activer_session($auteur) {

	// spip_log("JWS::ActiverSession - Auteur: $auteur","jws."._LOG_INFO_IMPORTANTE);
	$champs = array('id_auteur',
		'nom','email','login',
		'statut','webmestre',
		'maj','source','lang'
		);
	$row = sql_fetsel($champs,'spip_auteurs','id_auteur='.intval($auteur));
	if($row) {
		// spip_log("JWS::ActiverSession - base: ". print_r($row,true) ,"jws."._LOG_INFO_IMPORTANTE);
		$GLOBALS['visiteur_session']=$row;
		$GLOBALS['visiteur_session']['ip_change'] = false;
		// spip_log("JWS::ActiverSession - session: ". $GLOBALS['visiteur_session']['id_auteur'],"jws."._LOG_INFO_IMPORTANTE);
		return true;
	}
	spip_log("JWS::ActiverSession - Echec: $auteur","jws."._LOG_INFO_IMPORTANTE);
	return false;
}

/* -- OBSOLETE -- 
function jws_declarer_api($serveur,$connect,$charger,$chargerv2) {
	$api = "recobs.json";
	$reponse = array(
		"serverName" => $serveur,
		"connect" => $connect,
		"receiveObs" => $charger,
		"receiveObsV2" =>$chargerv2
		);
	$txt = json_encode($reponse);
	file_put_contents($api,$txt);
}
*/
?>