<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         dédié à la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a été développé initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.         *
 *  Pour plus de détails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

include_spip("inc/autoriser");
include_spip("inc/obsutil");
include_spip('base/abstract_sql');
include_spip('inc/invalideur');

function formulaires_affecter_observation_charger_dist($id_observation=0, $redirect='') {
	// verifier les droits
	if(!autoriser('modifier', 'observation', $id_observation)) {
		return false;
	}
	// est-ce une observation d'espèce ?
	if(sql_getfetsel('type_obs','spip_biodiv_observations',"id_observation=".intval($id_observation)) != 'espece') {
		return false;
	}
	// Initialisation du formulaire
	$valeurs = array(
		'id_observation' => $id_observation 	// identifiant de l'observation
	);	
	return $valeurs;
}



function formulaires_affecter_observation_verifier_dist($id_observation=0, $redirect='') {

	$erreurs = array();
	// cohérence aller-retour
	$idobs = _request('id_observation');
	if(intval($idobs)!=intval($id_observation)) {
		$erreurs['message_erreur'] = _T('biodiv:erreur_ref_observation');
		// $erreurs['redirect'] = $redirect;
		return $erreurs;
	}
	
	// éviter les doublons
	$idobj = _request('id_objet');
	$objet = _request('objet');
	if(sql_countsel('spip_biodiv_observations_liens',
		array("id_objet=".sql_quote($idobj),
			"objet=".sql_quote($objet),
			"id_observation=".sql_quote($idobs)
			))) {
		$erreurs['message_erreur'] = _T('observation:erreur_lien_observation');
		// $erreurs['redirect'] = $redirect;
		return $erreurs;
	}
	
	
	// Pour les campagnes, vérifier que l'observation est dans le périmètre
	// et que la date d'observation est dans la période de la campagne
	include_spip('inc/u_campagnes');
	if($objet == "campagne") {
		if(is_string($msg=observation_pour_campagne($id_observation,$idobj))) {
			spip_log("Observation $id_observation non affectee a la campagne $idobj : $msg","biodiv."._LOG_INFO_IMPORTANTE);
			$erreurs['message_erreur'] = $msg;
			return $erreurs;	
		}
	}
	
	// Tout est ok
	return $erreurs;
}

function formulaires_affecter_observation_traiter_dist($id_observation=0,$redirect='') {
	spip_log("[Biodiv] -- Traitement - DEBUT", "Affecter");
	$idobs = _request('id_observation');
	$idobj = _request('id_objet');
	$objet = _request('objet');
	sql_insertq('spip_biodiv_observations_liens', array(
		"id_objet" => intval($idobj),
		"objet" => $objet,
		"id_observation" => intval($idobs)
		));
	pipeline('apres_lien_observation',array(
		'id_observation' => $idobs,
		'objet' => $objet,
		'nature' => $objet,
		'id_objet' => $idobj
		));		
	suivre_invalideur("id='observation/$idobs'");
	$resultat = array(        
			'message_ok' => _T('observation:affectation_reussie'),
			// 'redirect' => $redirect,
			);

	return $resultat;
}


?>
