<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         ddi  la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a t dvelopp initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu sous licence GNU/GPL.         *
 *  Pour plus de dtails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/


function formulaires_exporter_biodiv_lieu_charger_dist() {

	return array();
}

function formulaires_exporter_biodiv_lieu_verifier_dist() {
	// Controles
	$erreurs = array();
	foreach(array('de','a') as $champ) {		
		if(!_request($champ)) {
			$erreurs[$champ] = "Champ obligatoire";
		} else {
			$val= _request($champ);
			$matches = array();
			if(!(preg_match('/([1-2][0-9]{3})[\-]([0-1][0-9])[\-]([0-3][0-9])/',$val,$matches)
				&& checkdate($matches[2],$matches[3],$matches[1]))) {
				$erreurs[$champ] = "Mauvais format de date ";
				}
		}
	}
	
	if(!_request('regne')) {
			$erreurs['regne'] = "Champ obligatoire";	
	} else {
		if(!sql_countsel("spip_taxons","regne=".sql_quote(_request('regne')))) {
			$erreurs['regne'] = "R&egrave;gne inconnu";
		}
	}
		
	return $erreurs;
}


function formulaires_exporter_biodiv_lieu_traiter_dist() {
	// Traitement
	$redirect = get_spip_script('./')
		. '?page='._request('format').'_regne_lieu'
		. '&de='._request('de')
		. '&a=' ._request('a')
		. '&regne=' ._request('regne')
		. '&perimetre=' ._request('perimetre');
	return array('redirect' => $redirect);
}


?>
