<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         d�di� � la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a �t� d�velopp� initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu� sous licence GNU/GPL.         *
 *  Pour plus de d�tails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

/*
**	FORMULAIRE_LIER_FAMILLE{�ID_RUBRIQUE,�URL}
**	S'appelle sur une rubrique, pour y lier une observation 
*/

function formulaires_lier_famille_charger_dist($cle_rubrique=0,$redirect='') {
	if(intval($cle_rubrique)<=0) {
		// protection contre les d�fauts d'appel
		return;
	}

	$valeurs = array(
		'id_rubrique' => $cle_rubrique,
		);
	return $valeurs;
}

function formulaires_lier_famille_verifier_dist($cle_rubrique=0,$redirect='') {
	// Controles
	$erreurs = array();
	if (intval(_request('id_observation'))==(-1)) $erreurs['id_observation'] = _T("observation:msg_lier_selection_obligatoire");
	if (!_request('id_rubrique')) $erreurs['id_rubrique'] = _T("observation:msg_lier_erreur_contexte");
	if(count($erreurs)) {
		$erreurs['message_erreur'] = _T("observation:msg_lier_abandon");
	}
	return $erreurs;
}

include_spip('base/abstract_sql');
include_spip('inc/invalideur');

function formulaires_lier_famille_traiter_dist($cle_rubrique=0,$redirect='') {
	// Traitement
    
	$cle_obs= intval(_request('id_observation'));
	$id_rubrique = intval(_request('id_rubrique'));
	$champs_utiles = array(
		"id_famille" => $id_rubrique
		);

	if($r = sql_updateq('spip_biodiv_observations',$champs_utiles,"id_observation=$cle_obs")) {
		$follow_up = _T("observation:msg_lier_ok",array("obs" => $cle_obs));
		// Pipeline
		pipeline('apres_lien_observation',array(
			'id_observation' => $cle_obs,
			'objet' => 'rubrique',
			'nature' => 'famille',
			'id_objet' => $id_rubrique
			));		
		// Invalider les caches
		suivre_invalideur("id='rubrique/$id_rubrique'");
		suivre_invalideur("id='observation/$cle_obs'");
		return array('message_ok'=>$follow_up);
	} else {
		$follow_up = _T("observation:msg_lier_echec", array("err" => $r, "obs" => $cle_obs));
		return array('message_erreur'=>$follow_up);
	}
}


?>
