<?xml version="1.0" encoding="iso-8859-1"?>

<!--

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         ddi  la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a t dvelopp initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu sous licence GNU/GPL.         *
 *  Pour plus de dtails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

  Document   : freemind-spip.xsl
  Version    : 0.1
  Created on : 12 Decembre 2014
  Author     : renaud.laurette
  Comment    : 
-->

<xsl:stylesheet 
		xmlns:gpx="http://www.topografix.com/GPX/1/1"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:geotracker="http://ilyabogdanovich.com/gpx/extensions/geotracker"
		version="1.0"
		>

<!-- Sortie avec caractres US pour forcer entites XML -->
  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" standalone="yes"/> 

  <xsl:template match="/">
    <xsl:element name="ordresBiodiv">
      <xsl:apply-templates select="//gpx:wpt" />
    </xsl:element>
  </xsl:template>
   
   <xsl:template match="gpx:wpt">
    <xsl:if test="starts-with(gpx:name,'o/')">
       <xsl:variable name="eName" select="normalize-space(substring-after(gpx:name,'o/'))"/>
     	<xsl:element name="creer">
     	  <xsl:attribute name="xObjet">observation</xsl:attribute>   
     	  <xsl:choose>
          	<xsl:when test="contains($eName,'/')">
          		<xsl:variable name="eEspece" select="normalize-space(substring-before($eName,'/'))"/>
          		<xsl:variable name="eSuite" select="normalize-space(substring-after($eName,'/'))"/>
          		<xsl:attribute name="espece"><xsl:value-of select="$eEspece"/></xsl:attribute>
          		<xsl:choose>
          			<xsl:when test="contains($eSuite,'/')">
          				<xsl:variable name="eQuantite" select="normalize-space(substring-before($eSuite,'/'))"/>
          				<xsl:variable name="eTitre" select="normalize-space(substring-after($eSuite,'/'))"/> 
          				<xsl:attribute name="titre"><xsl:value-of select="$eTitre"/></xsl:attribute>
          				<xsl:attribute name="quantite"><xsl:value-of select="$eQuantite"/></xsl:attribute>
          			</xsl:when>                        
          			<xsl:otherwise>
          				<xsl:attribute name="titre"><xsl:value-of select="$eEspece"/></xsl:attribute>
          				<xsl:attribute name="quantite"><xsl:value-of select="$eSuite"/></xsl:attribute>
          			</xsl:otherwise>
          		</xsl:choose>
          	</xsl:when>
          	<xsl:otherwise>
          	   	 <xsl:attribute name="titre"><xsl:value-of select="$eName"/></xsl:attribute>
          	   	 <xsl:attribute name="espece"><xsl:value-of select="$eName"/></xsl:attribute>
          	   	 <xsl:attribute name="quantite">1</xsl:attribute>
          	</xsl:otherwise>
       </xsl:choose>
          	     
       <xsl:variable name="eHour" select="substring(substring-after(gpx:time,'T'),1,2)"/>  
       <xsl:attribute name="lat"><xsl:value-of select="@lat"/></xsl:attribute>
       <xsl:attribute name="lng"><xsl:value-of select="@lon"/></xsl:attribute>
     	  
     	  <xsl:attribute name="date"><xsl:value-of select="normalize-space(substring-before(gpx:time,'T'))"/></xsl:attribute>
          <xsl:choose>
          	<xsl:when test="$eHour &lt; 6">
          	   <xsl:attribute name="pjour">lever du soleil</xsl:attribute>
          	</xsl:when>   
          	<xsl:when test="$eHour &lt; 12">
          	   <xsl:attribute name="pjour">matin</xsl:attribute>
          	</xsl:when>   
          	<xsl:when test="$eHour &lt; 18">
          	   <xsl:attribute name="pjour">apres-midi</xsl:attribute>
          	</xsl:when> 
          	<xsl:when test="$eHour &lt; 21">
          	   <xsl:attribute name="pjour">coucher du soleil</xsl:attribute>
          	</xsl:when> 
          	<xsl:otherwise>
          	   <xsl:attribute name="pjour">nuit</xsl:attribute>
          	</xsl:otherwise>
          	</xsl:choose>
     	</xsl:element>
     </xsl:if>
   </xsl:template>
   
  <xsl:template match="text()"/>

  
 </xsl:stylesheet>
