<?php
/**
 * Options au chargement du plugin nospam
 * Ajouts par rapport au plugin distribué
 *
 * @package    Spip\plugins\Nospam\extension
 * @copyright  2020
 * @author     Renaud LAURETTE
 */
 
 
/**
 * Détermination de l'adresse IP de l'émetteur
 *
 * Fonction pas complètement fiable en raison de la possibilité de falsifier le HTTP_X_FORWARDED_FOR
 * Utilisée seulement pour tracer les IP déclarées par les spammeurs
 * Ne pas utiliser pour sécuriser un accès
 *
 * @return ip-address
 */
 
function getClientIP() {
  if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
    $ip = $_SERVER['HTTP_CLIENT_IP'];
  } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
  } else {
    $ip = $_SERVER['REMOTE_ADDR'];
  }
  return $ip;
}


/**
 * Déclaration du pipeline et ajout du détecteur de spam
 */

if (!isset($GLOBALS['spip_pipeline']['formulaire_verifier'])) {
	$GLOBALS['spip_pipeline']['formulaire_verifier'] = '';
}
$GLOBALS['spip_pipeline']['formulaire_verifier'] .= "|spam_xxx";

/**
 * Génération d'une trace à chaque tentative de Spam
 *
 * Pour chaque tentative d'inscription détectée comme suspecte,
 * Génère un objet JSON ajouté en fin d'un fichier de trace
 *
 * @used-by spam_xxx
 * @see tmp/spammers.log
 */

function trackSpammerInscription() {
	$trackFile = _NOM_TEMPORAIRES_INACCESSIBLES. 'spammers.log';
	$hist = file_exists($trackFile) ? file_get_contents($trackFile) : "";
	$spammer = array(
		'action' => 'inscription',
		'mail' => _request('mail_inscription'),
		'nom' => _request('nom_inscription'),
		'ip' => getClientIP(),
		'date' => date(DATE_ATOM)
		);
	$hist .= json_encode($spammer) . ",\n";
	file_put_contents($trackFile,$hist);
}
		

/**
 * Pipeline destiné à empécher certains domaines et certains logins de s'inscrire
 *
 * Intercepte la fonction vérifier du formulaire d'inscription
 *
 * @param Array $flux	Paramètres du pipeline
 * @return Array		Paramètres modifiés
 *
 * @use trackSpammerInscription
 */
 
function spam_xxx($flux) {
	
	// Domaines à exclure
	$spam_domains = array(
		'@qq.com'			// mails spammeurs : nnnn@qq.com
		);
	
	// logins à exclure
	$spam_logins = array(
		'/xsqmai/',		// Site spammeur : www.xsqmai.com
		'/\p{Han}+/u'	// Les caractères chinois
		);
	
	$spam_ips = array(
		'/^51\.222\.253/'	// Dmytro, Ahrefs Pte Ltd
		);
	
	if ($flux['args']['form'] == 'inscription'){
		foreach($spam_domains as $spd) {
			if (strpos(_request('mail_inscription'), $spd)) {
				$flux['data']['mail_inscription'] = 'spam detected';
				trackSpammerInscription();
				return $flux;
			}
		}
		foreach($spam_logins as $spl) {
			if (preg_match($spl, _request('nom_inscription'))) {
				$flux['data']['nom_inscription'] = 'spam detected';
				trackSpammerInscription();
				return $flux;
			}
		}
		
		$cip = getClientIP();
		foreach($spam_ips as $spi) {
			if(preg_match($spi,$cip)) {
				$flux['data']['nom_inscription'] = 'spam detected';
				trackSpammerInscription();
				return $flux;
			}
		}
		
    }
    return $flux;
}



?>