<?php
/*******************************************************************************\
 * REBOND, plugin et squelette pour SPIP - https://www.spip.net/               *
 *                                                                             *
 *         Copyright (C) 2008-2021 Renaud LAURETTE                             *
 *                                                                             *
\*******************************************************************************/

function formulaires_declarer_ressource_charger($objet=null,$idobj=0,$redirect='') {
	// verifier les droits
	if(!autoriser('modifier', $objet, $idobj)) {
		return false;
	}	
	return  array();	
}

function formulaires_declarer_ressource_verifier($objet=null,$idobj=0,$redirect='') {
	$rsc_data = array(); $rsc_desc = "";
	$ok = false;
	
	// lecture du fichier de configuration du plugin
	$conf = file_get_contents(_DIR_REBOND_CONFIG . 'ressources.json');
	$rsc = json_decode($conf, true);
	$rsc = $rsc['ressources'];

	// Quel est le type de ressource choisi ?
	$r = _request('typersc');
	if($r) {
		// Prparation de la structure de donnes  sauvegarder
		$rsc_data["_type"] = 'Rebond';
		$rsc_data["_ressource"] = $r;
		// On balaye les ressources dclares dans la configuration
		foreach($rsc as $ressource) {
			$n = $ressource['nom'];
			$p = $ressource['prefixe'];
			$c = $ressource['clefs'];		
			if($n == $r) {
				// On a trouv le type de ressource demand
				$ok = true;
				$rsc_data["_modele"] = $p;
				$label = _T('rebond:nom-'.$n);
				$rsc_desc .= $label . "\n";
				// On balaye les paramtres d'appel
				foreach($c as $clef) {
					$cn = $clef['nom'];		// nom dans la configuration
					$k = $p.'-'.$cn;		// nom dans le formulaire
					$cv = _request($k);	
					// pour viter les ataques cross-scripting,
					// on vrifie le contenu du paramtre
					$pat = ',^('.$clef['masque'].')$,';
					preg_match($pat,$cv,$m);
					// $erreurs['message_ok'] .= print_r($cv,true)."/".print_r($clef['masque'],true) . "/".print_r($m,true);
					if(!isset($m[1])) {
						// tentative de tromperie : on ignore
						$ok = false;
					} else {
						// la forme est bonne, on l'enregistre
						$rsc_data["_clefs"][$cn] = $m[1];
						$label = _T('rebond:clef-'.$cn);
						$rsc_desc .= $label . ': ' . $m[1] . "\n";
					}
				}
			}
		}
	} 
	
	// A-t-on tout ce qu'il faut ?
	if(!$ok) {
		$erreurs['message_erreur'] = _T('rebond:mauvaise_definition');
		return $erreurs;
	}
	
	// Les donnes soumises sont correctes.
	// On linarise en JSON et on enregistre.
	$upload_dir = _DIR_TMP . "upload/";
	$file = tempnam($upload_dir,'reb');
	$data = json_encode($rsc_data);
	$success = file_put_contents($file, $data);
	if($success) {
		// on propage discrtement l'adresse du rsultat
		$_POST['_rsc_file_'] = $file;
		$_POST['_rsc_desc_'] = $rsc_desc;
		return array();
	} else {
		$erreurs['message_erreur'] = _T('rebond:echec_linearisation');
		return $erreurs;
	}	
}


function formulaires_declarer_ressource_traiter($objet=null,$idobj=0,$redirect='') {
	include_spip('action/ajouter_documents');
	$ajouter_un_document = charger_fonction('ajouter_un_document', 'action');
	
	$file = $_POST['_rsc_file_']; 				// fichier temporaire
	$nbr = sql_countsel('spip_documents_liens',"(id_objet=$idobj) AND (objet='$objet')");
	$rebond = 'r'.$idobj.'_'.$nbr.'.rebond';	// fichier cible
	$download = array(
		'name' => $rebond,
		'tmp_name' => $file,
		'type' => 'text/plain',
		'size' => filesize($file),
		'error' => UPLOAD_ERR_OK
		);

	// on a verifi les droits au chargement, on peut donc ajouter le document sur l'objet
	$docid = $ajouter_un_document('new',$download,$objet,$idobj,'document');
	if($docid) {
		spip_log("[Rebond] -- Creation du document $docid");
		spip_unlink($file);
		sql_updateq('spip_documents',
				array('descriptif' => $_POST['_rsc_desc_']),
				"id_document=".intval($docid)
				);	
		$resultat = array(
			'message_ok' => _T('rebond:rebond_enregistre'),
			'redirect' => $redirect,
			);	
		return $resultat;
	}
	
	spip_log("[Rebond] -- Echec creation du rebond - voir $file",_LOG_INFO_IMPORTANTE);	
	$resultat = array(
		'message_ok' => _T('rebond:rebond_echoue'),
		);	
	return $resultat;
}

?>