/**
 * Filtre les bases proposées par l'api TAXREF
 * https://taxref.mnhn.fr/api/externalDb/
 * Pour ne retenir que les plus intéressantes
 */
 
function baseBiodivValide(nom) {
	const validDB = [
		"ANTCAT",						// An Online Catalog of the Ants of the World
		"Avibase",						// The world bird database
		"BDTFX", 						// Base de données des Trachéophytes de France métropolitaine (Tela Botanica)
		"BRYO_FR_FCBN",					// Référentiel des mousses, hépatiques et anthocérotes de France métropolitaine de la FCBN
		"EASIN",						// Réseau européen d’information sur les espèces exotiques
		"The World Spider Catalog",
		"GBIF", 						// Global Biodiversity Information Facility
		"WFO (World Flora Online)", 
		"WoRMS"							// World Register of Marine Species
	];
	return validDB.includes(nom);
}

function statusBiodivValide(item,taxon) {
	const typesGroup = [
		'Liste rouge',
		'Protection',
	];
	const locationIds = [
		'WORLD',		// Monde
		'EUROPE',		// Europe
		'TERFXFR',		// France métropolitaine
		'INSEER73',		// Midi-Pyrénées
		'INSEER76',		// Occitanie
		'INSEED31'		// Haute-Garonne
	];
	const excludedStatus = [
		'NA'			// Non applicable
	];
	
	return (
		typesGroup.includes(item.statusTypeGroup) &&
		locationIds.includes(item.locationId) &&
		(!excludedStatus.includes(item.statusCode)) &&
		(item.taxon.referenceId == taxon)
		);
}