/**
 * Fonctions ajoutant du contenu aux fiches espèces
 * sur la base de photos et de l'API Taxref
 */
 
  var affichePhotos = function(domId) {
  	  return function(data) {
  	  	  if(data.images) {
  	  	  	  var laDiv = document.getElementById(domId);
  	  	  	  data.images.map(function(item) {
  	  	  	  	var tx = `<a href="${item.src}" type="${item.type}" title="${item.titre} - Doc ${item.doc} - Credit ${item.credits}"><img src="${item.src}"/></a>`;
  	  	  	  	laDiv.innerHTML += tx;
  	  	  	  });
  	  	  	  (function($) { $(mediaboxInit); })(jQuery);  // Forcer la prise en compte d'Ajax par Spip pour que les images bénéficient du plugin mediabox.
  	  	  }
  	  };
  };

  var afficheXRefs = function(domId) {
  	  return function(data) {
  	  	  if(data._embedded && data._embedded.externalDb) {
  	  	  	  var xrefs = data._embedded.externalDb;
  	  	  	  var uList = document.getElementById(domId);
  	  	  	  xrefs.map(function(item) { 
  	  	  	  		  if(baseTaxrefValide(item.externalDbName)) {
  	  	  	  		  	  var tx = `<li><span class="w-icon w-icon-database"></span><a target="_blank" title="${item.externalDbTitle} : ${item.externalId}" href="${item.url}">${item.externalDbName}</a></li>`;
  	  	  	  		  	  uList.innerHTML += tx;
  	  	  	  		  }
  	  	  	  });
  	  	  }
  	  };
  };
  
  var afficheStatus = function(domId,taxon) {
  	  return function(data) {
  	  	  if(data._embedded && data._embedded.status) {
  	  	  	  var status = data._embedded.status;
  	  	  	  var uList = document.getElementById(domId);
  	  	  	  var lis = '';
  	  	  	  status.map(function(item) { 
  	  	  	  		  if(statusTaxrefValide(item,taxon)) {
  	  	  	  		  	  var tx = `<li class="unStatus">${item.statusTypeGroup} ${item.locationName} : ${item.statusCode} <span class="detailStatus">${item.statusTypeGroup} ${item.locationName} : ${item.statusName}</span></li>`;
  	  	  	  		  	  lis += tx;
  	  	  	  		  }
  	  	  	  });
  	  	  	  uList.innerHTML = '<h3>Statuts</h3><ul>'+lis+'</ul>';
  	  	  }
  	  };
  };
