<?php
/**
 * Utilisation de l'action supprimer pour l'objet taxref
 *
 * @plugin     Biodiv
 * @copyright  2024
 * @author     Renaud LAURETTE
 * @licence    GNU/GPL
 * @package    SPIP\Biodiv\Action
 */

if (!defined('_ECRIRE_INC_VERSION')) {
	return;
}



/**
 * Action pour supprimer un taxref
 *
 * Vérifier l'autorisation avant d'appeler l'action.
 *
 * @example
 *     ```
 *     [(#AUTORISER{supprimer, taxref, #ID_TAXREF}|oui)
 *         [(#BOUTON_ACTION{<:taxref:supprimer_taxref:>,
 *             #URL_ACTION_AUTEUR{supprimer_taxref, #ID_TAXREF, #URL_ECRIRE{taxrefs}},
 *             danger, <:taxref:confirmer_supprimer_taxref:>})]
 *     ]
 *     ```
 *
 * @example
 *     ```
 *     [(#AUTORISER{supprimer, taxref, #ID_TAXREF}|oui)
 *         [(#BOUTON_ACTION{
 *             [(#CHEMIN_IMAGE{taxref-del-24.png}|balise_img{<:taxref:supprimer_taxref:>}|concat{' ',#VAL{<:taxref:supprimer_taxref:>}|wrap{<b>}}|trim)],
 *             #URL_ACTION_AUTEUR{supprimer_taxref, #ID_TAXREF, #URL_ECRIRE{taxrefs}},
 *             icone s24 horizontale danger taxref-del-24, <:taxref:confirmer_supprimer_taxref:>})]
 *     ]
 *     ```
 *
 * @example
 *     ```
 *     if (autoriser('supprimer', 'taxref', $id_taxref)) {
 *          $supprimer_taxref = charger_fonction('supprimer_taxref', 'action');
 *          $supprimer_taxref($id_taxref);
 *     }
 *     ```
 *
 * @param null|int $arg
 *     Identifiant à supprimer.
 *     En absence de id utilise l'argument de l'action sécurisée.
**/
function action_supprimer_taxref_dist($arg=null) {
	if (is_null($arg)){
		$securiser_action = charger_fonction('securiser_action', 'inc');
		$arg = $securiser_action();
	}
	$arg = intval($arg);

	// cas suppression
	if ($arg) {
		sql_delete('spip_taxrefs',  'id_taxref=' . sql_quote($arg));
	}
	else {
		spip_log("action_supprimer_taxref_dist $arg pas compris");
	}
}
