<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         dédié à la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a été développé initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.         *
 *  Pour plus de détails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

if (!defined('_ECRIRE_INC_VERSION')) return;

define('_LOGOMIG_QUANTITE',10);		// nombre de logos traités en une itération dans chaque catégorie



/**
 * Convertir des logos
 *
 * @param int $t
 * @return int
 */
function genie_logomig_dist($t) {
	$logotypes = array(
		'arton' => 'article',
		'auton' => 'auteur',
		'breveon' => 'breve',
		'moton' => 'mot',
		'rubon' => 'rubrique',
		'siteon' => 'site',
		'campagneon' => 'campagne'
		); 
	$out = array();
	$entries = array_diff(scandir(_ROOT_RACINE . _NOM_PERMANENTS_ACCESSIBLES),array('..','.'));
	foreach($logotypes as $logo => $type) {
		$images = array_values(preg_grep("/^$logo(\d+)\./",$entries));
		// spip_log("LOGOS - Liste ($logo,$type) " . print_r($images,true),"biodiv."._LOG_INFO_IMPORTANTE);
		$s = count($images);
		$s = ($s < _LOGOMIG_QUANTITE) ? $s : _LOGOMIG_QUANTITE;
		for($i=0; $i < $s; $i++) {
			spip_log("LOGOS - Creation document pour ($logo,$type) " . $images[$i],"biodiv."._LOG_INFO_IMPORTANTE);
			$out[] = logomig_creer_un_document($images[$i],$logo,$type);
		}
	}
	return(1);	
}


include_spip('action/ajouter_documents');
include_spip('action/editer_liens');

function logomig_creer_un_document($file,$logo,$type) {
	$mimes = array(
		'jpg' => 'image/jpeg',
		'jpeg' => 'image/jpeg',
		'png' => 'image/png',
		'gif' => 'image/gif'
		);
	$docid = -1;
	$ajouter_un_document = charger_fonction('ajouter_un_document', 'action');
	$ext = substr(strrchr($file,'.'),1);
	$pattern = "/$logo([\d]+)\.$ext$/";
	preg_match($pattern,$file,$matches);
	if(in_array($ext,array_keys($mimes)) and isset($matches[1])) {
		$oid = $matches[1];
		$download = array(
			'name' => $file,
			'tmp_name' => _ROOT_RACINE . _NOM_PERMANENTS_ACCESSIBLES.$file,
			'type' => $mimes[$ext],
			'size' => filesize(_ROOT_RACINE . _NOM_PERMANENTS_ACCESSIBLES.$file),
			'error' => UPLOAD_ERR_OK
			);
		// $docid = $ajouter_un_document('new',$download,$type,$matches[1],'image');
		$docid = $ajouter_un_document('new',$download,null,null,'image');
		spip_log("LOGOS - Ajout document $docid pour ($logo,$type,$oid) " . $download['tmp_name'],"biodiv."._LOG_INFO_IMPORTANTE);
		if(intval($docid) >0) {
			objet_associer(
				array('document' => $docid),
				array($type => $oid),
				array('role' => 'logo')
				);
			/*
			sql_updateq('spip_documents_liens',
				array('role'=>'logo'),
				array(
					'id_document='.$docid,
					'objet='.sql_quote($type),
					'id_objet='.$oid,
					"role='document'"
					));	
					
			suivre_invalideur("id='$type/$oid'");
			*/
			/*
			$qualifier = sql_fetsel(
				array('vu','rang_lien'),
				'spip_documents_liens',
				array(
					'id_document=' . $docid,
					'objet=' . sql_quote($type),
					'id_objet=' . $matches[1],
					'role=' . sql_quote('document')
					)
				);
			objet_qualifier_liens(
				array('document'=> $docid), 
				array($type => $matches[1]), 
				array('role'=>'logo') + $qualifier
				);
				*/
			unlink(_ROOT_RACINE . _NOM_PERMANENTS_ACCESSIBLES.$file);
			spip_log("LOGOS - Creation document $docid reussie ($logo,$type) pour $file","biodiv."._LOG_INFO_IMPORTANTE);
		} else {                                                                                          
			spip_log("LOGOS - Echec creation document ($logo,$type) pour $file","biodiv."._LOG_INFO_IMPORTANTE);
		}
	} else {
		spip_log("LOGOS - Echec migration $file ($logo,$type)","biodiv."._LOG_INFO_IMPORTANTE);
	}
	return $docid;
}


?>
