<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         dédié à la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2025 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a été développé initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : https://apcveb.fr/                                        *
 *                                                                             *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.         *
 *  Pour plus de détails voir les fichiers COPYING.txt et LICENCE-BIODIV.md    *
\*******************************************************************************/

if (!defined('_ECRIRE_INC_VERSION')) return;


/**
 * Force à discret la confidentialité des taxons sensibles
 * Récupère en tâche de fond les observations dont le taxon a changé de sensibilité après le lien à l'espèce
 *
 * @param int $t
 * @return int
 */
function genie_sensible_dist($t) {
	$rows = sql_allfetsel('id_espece','spip_taxrefs','sensible='.sql_quote('oui'));
	$especes = array();
	foreach($rows as $row) {
		$especes[] = $row['id_espece'];
	}
	$in = sql_in('id_espece',$especes);
	sql_updateq('spip_biodiv_observations', array{'discret' => 'oui'}, $in);
	return(1);
}

?>