<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         d�di� � la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a �t� d�velopp� initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu� sous licence GNU/GPL.         *
 *  Pour plus de d�tails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

/*
**	FORMULAIRE_DELIER_ESPECE{�ID_ARTICLE,�URL}
*/

function formulaires_delier_sujet_charger_dist($cle_article=0,$redirect='') {
	if(intval($cle_article)<=0) {
		// protection contre les d�fauts d'appel
		return;
	}

	$valeurs = array(
		'id_article' => $cle_article,
		);
	return $valeurs;
}

function formulaires_delier_sujet_verifier_dist($cle_article=0,$redirect='') {
	// Controles
	$erreurs = array();
	if (intval(_request('id_observation'))==(-1)) $erreurs['id_observation'] = _T("observation:msg_lier_selection_obligatoire");
	if (!_request('id_article')) $erreurs['id_article'] = _T("observation:msg_lier_erreur_contexte");
	if(count($erreurs)) {
		$erreurs['message_erreur'] = _T("observation:msg_lier_abandon");
	}
	return $erreurs;
}

include_spip('base/abstract_sql');
include_spip('inc/invalideur');
	
function formulaires_delier_sujet_traiter_dist($cle_article=0,$redirect='') {
	// Traitement
	$cle_obs= intval(_request('id_observation'));
	$article = intval(_request('id_article'));
	$champs_utiles = array(
		"id_sujet" => 0
		);

	if($r = sql_updateq('spip_biodiv_observations',$champs_utiles,"(id_observation=$cle_obs) AND (id_sujet=$article)")) {
		$follow_up = _T("observation:msg_delier_ok",array("obs" => $cle_obs));
		// pipeline
		pipeline('apres_lien_observation',array(
			'id_observation' => $cle_obs,
			'objet' => 'article',
			'nature' => 'sujet',
			'id_objet' => 0
			));	
		// Invalider les caches
		suivre_invalideur("id='observation/$cle_obs'");
		suivre_invalideur("id='article/$article'");
		return array('message_ok'=>$follow_up);
	} else {
		$follow_up = _T("observation:msg_delier_echec", array("err" => $r, "obs" => $cle_obs));
		return array('message_erreur'=>$follow_up);
	}
}


?>
