<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         d�di� � la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a �t� d�velopp� initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu� sous licence GNU/GPL.         *
 *  Pour plus de d�tails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

/*
**	FORMULAIRE_LIER_SUJET{�ID_ARTICLE,�URL}
**	S'appelle sur un article, pour y lier une observation suivant un type
**	de lien qui peut �tre 'espece' ou 'endroit'
*/

include_spip('base/abstract_sql');
include_spip('inc/invalideur');

function formulaires_lier_sujet_charger_dist($cle_article=0,$redirect='') {
	if(intval($cle_article)<=0) {
		// protection contre les d�fauts d'appel
		return;
	}

	$valeurs = array(
		'id_article' => $cle_article,
		);
	return $valeurs;
}

function formulaires_lier_sujet_verifier_dist($cle_article=0,$redirect='') {
	// Controles
	$erreurs = array();
	$idobs = intval(_request('id_observation'));
	if ($idobs==(-1)) {
		$erreurs['id_observation'] = _T("observation:msg_lier_selection_obligatoire");
		return $erreurs;
	}
	$tobs = sql_getfetsel('type_obs','spip_biodiv_observations',"id_observation=$idobs");
	/* 
	 * Relachement du contr�le : 
	 * Finalement on autorise tous les types d'observation, car un sujet peut apparaitre
	 * sur une observation de milieu. Comme une observation de milieu n'a pas d'esp�ce
	 * associ�e, l'ajout de ce type d'observation ne perturbe pas l'affichage de la page
	 * du sujet.
	 *
	if($tobs != 'espece') {
		$erreurs['id_observation'] = _T("observation:msg_lier_erreur_type");
	}
	*/
	if (!_request('id_article')) $erreurs['id_article'] = _T("observation:msg_lier_erreur_contexte");
	// verifier aussi que l'article correspond � un sujet ...
	if(count($erreurs)) {
		$erreurs['message_erreur'] = _T("observation:msg_lier_abandon");
	}
	return $erreurs;
}

function formulaires_lier_sujet_traiter_dist($cle_article=0,$redirect='') {
	// Traitement
	    
	$cle_obs= _request('id_observation');
	$id_article =  intval(_request('id_article'));
	
	$champs_utiles = array(
		"id_sujet" => $id_article
		);

	if($r = sql_updateq('spip_biodiv_observations',$champs_utiles,"id_observation=$cle_obs")) {
		$follow_up = _T("observation:msg_lier_ok",array("obs" => $cle_obs));
		// Pipeline
		pipeline('apres_lien_observation',array(
			'id_observation' => $cle_obs,
			'objet' => 'article',
			'nature' => 'sujet',
			'id_objet' => $id_article
			));	
		// Invalider les caches
		suivre_invalideur("id='article/$id_article'");
		suivre_invalideur("id='observation/$cle_obs'");
		return array('message_ok'=>$follow_up);
	} else {
		$follow_up = _T("observation:msg_lier_echec", array("err" => $r, "obs" => $cle_obs));
		return array('message_erreur'=>$follow_up);
	}
}


?>
