<?php
/**
 * Fichier gérant l'installation et désinstallation du plugin Feuillet
 *
 * @plugin     Feuillet
 * @copyright  2010-2021
 * @author     Renaud LAURETTE
 * @licence    GNU/GPL
 * @package    SPIP\Feuillet\Installation
 */

if (!defined('_ECRIRE_INC_VERSION')) {
	return;
}

include_spip('action/editer_objet');

/**
 * Fonction d'installation et de mise à jour du plugin Feuillet.
 *
 * @param string $nom_meta_base_version
 *     Nom de la meta informant de la version du schéma de données du plugin installé dans SPIP
 * @param string $version_cible
 *     Version du schéma de données dans ce plugin (déclaré dans paquet.xml)
 * @return void
**/
function feuillet_upgrade($nom_meta_base_version, $version_cible) {
	$maj = array();
	# quelques exemples
	# (que vous pouvez supprimer !)
	# 
	# $maj['create'] = array(array('creer_base'));
	#
	# include_spip('inc/config')
	# $maj['create'] = array(
	#	array('maj_tables', array('spip_xx', 'spip_xx_liens')),
	#	array('ecrire_config', 'biodiv', array('exemple' => "Texte de l'exemple"))
	#);
	#
	# $maj['1.1.0']  = array(array('sql_alter','TABLE spip_xx RENAME TO spip_yy'));
	# $maj['1.2.0']  = array(array('sql_alter','TABLE spip_xx DROP COLUMN id_auteur'));
	# $maj['1.3.0']  = array(
	#	array('sql_alter','TABLE spip_xx CHANGE numero numero int(11) default 0 NOT NULL'),
	#	array('sql_alter','TABLE spip_xx CHANGE texte petit_texte mediumtext NOT NULL default \'\''),
	#   array('une_fonction_sans_arguments_definie_dans_ce_fichier')
	# );
	# ...

	// Creation : installation complète
	$maj['create'] = array(
		array('feuillet_ajouter_types_documents')
		);
    
	include_spip('base/upgrade');
	maj_plugin($nom_meta_base_version, $version_cible, $maj);
}


/**
 * Fonction de désinstallation du plugin Feuillet.
 * 
 * Il faut :
 * - nettoyer toutes les données ajoutées par le plugin et son utilisation
 * - supprimer les tables et les champs créés par le plugin. 
 *
 * @param string $nom_meta_base_version
 *     Nom de la meta informant de la version du schéma de données du plugin installé dans SPIP
 * @return void
**/
function feuillet_vider_tables($nom_meta_base_version) {

	# Aucune action
	effacer_meta($nom_meta_base_version);
}

/**
 *  Ajout des types de documents pour les couches cartographiques
 */
function feuillet_ajouter_types_documents() {
	
	$newdocs = array(
		array(
			"extension"	=> "geojson",
			"titre"		=> "Fichier Geojson",
			"descriptif"=> " ",
			"mime_type"	=> "text/plain",
			"inclus"	=> "non",
			"upload"	=> "oui",
			"media"		=> "file"
			),
		array(
			"extension"	=> "gpx",
			"titre"		=> "Trace GPX",
			"descriptif"=> " ",
			"mime_type"	=> "text/plain",
			"inclus"	=> "non",
			"upload"	=> "oui",
			"media"		=> "file"
			),
		array(
			"extension"	=> "wkt",
			"titre"		=> "Well known text",
			"descriptif"=> " ",
			"mime_type"	=> "text/plain",
			"inclus"	=> "non",
			"upload"	=> "oui",
			"media"		=> "file"
			),			
		);	

	foreach($newdocs as $newdoc) {
		$ext = $newdoc['extension'];
		if(sql_countsel("spip_types_documents","extension='$ext'")==0) {
			$id = sql_insertq("spip_types_documents",$newdoc);
		}
	}
}
		


		
