<?php
/**
 * Utilisations de pipelines par Feuillet
 *
 * @plugin     Feuillet
 * @copyright  2010-2024
 * @author     Renaud LAURETTE
 * @licence    GNU/GPL
 * @package    SPIP\Feuillet\Pipelines
 */


if (!defined('_ECRIRE_INC_VERSION')) {
	return;
}


function feuillet_insert_head($flux)
{
	// Insertion des styles requis par la carte.
	$flux .="\n<!-- feuillet start -->";
	$flux .="\n".'<script src="'. url_absolue(find_in_path('lib/leaflet/leaflet.js')) .'"></script>';
	$flux .="\n".'<script src="'. url_absolue(find_in_path('lib/leaflet.draw/leaflet.draw.js')) .'"></script>';
	$flux .="\n".'<script src="'. url_absolue(find_in_path('lib/leaflet-omnivore/leaflet-omnivore.js')) .'"></script>';
	$flux .="\n".'<script src="'. url_absolue(find_in_path('lib/leaflet-fullscreen/Control.FullScreen.js')) .'"></script>';
	$flux .="\n".'<script src="'. url_absolue(find_in_path('lib/feuillet/feuillet.js')) .'"></script>';
	$flux .="\n".'<script src="'. url_absolue(find_in_path('lib/feuillet/feuillet-styles.js')) .'"></script>';
	$flux .="\n".'<link rel="stylesheet" href="'. url_absolue(find_in_path('lib/leaflet/leaflet.css')) .'" type="text/css" media="projection, screen, tv" />';
	$flux .="\n".'<link rel="stylesheet" href="'. url_absolue(find_in_path('lib/leaflet-fullscreen/Control.FullScreen.css')) .'" type="text/css" media="projection, screen, tv" />';
	$flux .="\n".'<link rel="stylesheet" href="'. url_absolue(find_in_path('lib/leaflet.draw/leaflet.draw.css')) .'" type="text/css" media="projection, screen, tv" />';
	$flux .="\n<!-- feuillet end -->";
	$flux .="\n";
	return $flux;
}    

function feuillet_header_prive($flux) {
	return feuillet_insert_head($flux);
}

?>
