<?php
/**
 * Fichier gérant l'installation et désinstallation du plugin Rebond
 *
 * @plugin     Biodiv
 * @copyright  2020
 * @author     Renaud LAURETTE
 * @licence    GNU/GPL
 * @package    SPIP\Biodiv\Installation
 */

if (!defined('_ECRIRE_INC_VERSION')) {
	return;
}

include_spip('action/editer_objet');

/**
 * Fonction d'installation et de mise à jour du plugin Rebond.
 *
 * Vous pouvez :
 *
 * - créer la structure SQL,
 * - insérer du pre-contenu,
 * - installer des valeurs de configuration,
 * - mettre à jour la structure SQL 
 *
 * @param string $nom_meta_base_version
 *     Nom de la meta informant de la version du schéma de données du plugin installé dans SPIP
 * @param string $version_cible
 *     Version du schéma de données dans ce plugin (déclaré dans paquet.xml)
 * @return void
**/
function rebond_upgrade($nom_meta_base_version, $version_cible) {
	$maj = array();
	# quelques exemples
	# (que vous pouvez supprimer !)
	# 
	# $maj['create'] = array(array('creer_base'));
	#
	# include_spip('inc/config')
	# $maj['create'] = array(
	#	array('maj_tables', array('spip_xx', 'spip_xx_liens')),
	#	array('ecrire_config', 'biodiv', array('exemple' => "Texte de l'exemple"))
	#);
	#
	# $maj['1.1.0']  = array(array('sql_alter','TABLE spip_xx RENAME TO spip_yy'));
	# $maj['1.2.0']  = array(array('sql_alter','TABLE spip_xx DROP COLUMN id_auteur'));
	# $maj['1.3.0']  = array(
	#	array('sql_alter','TABLE spip_xx CHANGE numero numero int(11) default 0 NOT NULL'),
	#	array('sql_alter','TABLE spip_xx CHANGE texte petit_texte mediumtext NOT NULL default \'\''),
	#   array('une_fonction_sans_arguments_definie_dans_ce_fichier')
	# );
	# ...

	// Creation : installation complète
	$maj['create'] = array();
    
	include_spip('base/upgrade');
	maj_plugin($nom_meta_base_version, $version_cible, $maj);
	rebond_controle_installation();
}


/**
 * Fonction de désinstallation du plugin Biodiv.
 * 
 * Vous devez :
 * - nettoyer toutes les données ajoutées par le plugin et son utilisation
 * - supprimer les tables et les champs créés par le plugin. 
 *
 * @param string $nom_meta_base_version
 *     Nom de la meta informant de la version du schéma de données du plugin installé dans SPIP
 * @return void
**/
function rebond_vider_tables($nom_meta_base_version) {

	effacer_meta($nom_meta_base_version);
}



/**
 * Fonction de vérification des installations spécifiques
 * 
 * @param void
 * @return void
**/
function rebond_controle_installation() {
		
	// Définir les fichiers GeoJSON
	if(!sql_countsel('spip_types_documents', "extension='rebond'")) {
		sql_insertq('spip_types_documents', array(
			'extension' => 'rebond', 'mime_type' => 'text/plain',
			'titre' => 'Rebond', 'inclus'=>'non', 'upload'=>'oui'));
		spip_log("[Rebond] Declaration type document rebond",_LOG_INFO_IMPORTANTE);
	}
	
	// Créer les répertoires spécifiques
	$repertoires = array('upload');
	foreach($repertoires as $rep) {
		$repertoire = _DIR_TMP . $rep;
		if(!is_dir($repertoire)) {
			if(!file_exists($repertoire)) {
				mkdir($repertoire);
				spip_log("[Rebond] Creation repertoire $repertoire",_LOG_INFO_IMPORTANTE);
			} else {
				spip_log("[Rebond] Impossible de creer repertoire '$repertoire' : un fichier du meme nom existe deja.", _LOG_INFO_IMPORTANTE);
			}
		}
	}
	
}

		
