<?xml version="1.0" encoding="iso-8859-1"?>

<!--
  Document   : fichepdf.xsl
  Version    : 2
  Created on : 30 Decembre 2020
  Author     : Renaud LAURETTE
  Licence    : GPL 3.0
  Comment    : 
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:svg="http://www.w3.org/2000/svg"
                exclude-result-prefixes="xalan"
                version="1.0">

  <!-- Type de sortie -->
  <xsl:output method="xml" version="1.0" encoding="UTF-8"/>
  
  <!-- Parametres d'appel -->
  <xsl:param name="id_espece" />
  
  <!-- MAPQUEST -->
  <xsl:variable name="cfMapperRoot" select="'https://www.mapquestapi.com/staticmap/v5/map?type=map'"/> 
  <xsl:variable name="cfMapperSmall" select="'&amp;size=495,250@2x'"/>
  <xsl:variable name="cfMapperLarge" select="'&amp;size=495,600@2x'"/>
  <xsl:variable name="cfMapperMarkerData" select="'&amp;defaultMarker=via-sm-0000ff&amp;locations='"/>
  <xsl:variable name="cfMapperPathData" select="'&amp;shape=border:ff0000ff%7Cweight:1%7Cfill:ff00ff33%7Ccmp%7Cenc:'"/>
  <xsl:variable name="cfMapperPathData2" select="'&amp;shape=cmp%7Cenc:'"/>
 
  <!-- Variables globales -->
  <xsl:variable name="context" select="/context"/>
  <xsl:variable name="source">
    <xsl:value-of select="$context/server"/>
    <xsl:text>spip.php?page=x_espece_2&amp;uid=</xsl:text>
    <xsl:value-of select="$id_espece"/>
  </xsl:variable>
  <xsl:variable name="fiche" select="document($source)"/>
  <xsl:variable name="cfBandeau">
    <xsl:value-of select="$context/server"/>
    <xsl:text>Rsc3/ws/img/bandeau.svg</xsl:text>
  </xsl:variable>
  
  <!-- keys-->
  <xsl:key name="observateur" match="auteur-ref" use="@id"/>
  
  <!-- observations associes  la fiche -->
   <xsl:variable name="obsfrag">
     <xsl:element name="observations">
       <xsl:for-each select="$fiche//espece/observation">
         <xsl:copy-of select="."/>
       </xsl:for-each>
     </xsl:element>
   </xsl:variable>   
   <xsl:variable name="observations" select="xalan:nodeset($obsfrag)"/>
  
      
  <!-- STRUCTURE du DOCUMENT -->
  
  <xsl:template match="/">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
      <xsl:call-template name="master-layout" />
      <fo:page-sequence master-reference="my-sequence">
        <!-- zones statiques -->
        <xsl:call-template name="headers" />
        <xsl:call-template name="footers" />
        <!-- Zone dynamique -->  
        <fo:flow flow-name="xsl-region-body">
        	 <fo:block 
        	 	text-align="center" text-indent="0cm"
        	 	font-family="Times" font-size="24pt" color="blue"
        	 	padding-top="25pt" padding-bottom="25pt" span="all"
        	 	 >
        	    <xsl:value-of select="$fiche//espece/titre"/>
        	    <fo:block font-style="italic">
                  <xsl:value-of select="$fiche//espece/titre/@latin"/>
                </fo:block>
        	  </fo:block>
        	 
        	  <xsl:apply-templates select="$fiche//espece" />
        	  <!--<fo:block page-break-after="always"/>-->
        	  
        	  <xsl:apply-templates select="$fiche//espece/graphique[@id='ObsParAnnees']">
        	     <xsl:with-param name="title" select="'Observations par anne'"/>
        	  </xsl:apply-templates>
        	  <xsl:apply-templates select="$fiche//espece/graphique[@id='ObsParMois']">
        	     <xsl:with-param name="title" select="'Observations par mois'"/>
        	  </xsl:apply-templates>	  
        	  <xsl:call-template name="carte" />
        	  <fo:block page-break-after="always"/>
        	  
        	  <xsl:call-template name="listePhotos" />
        	  <xsl:call-template name="observateurs"/>
        </fo:flow>
     <!-- Fin des pages -->
     </fo:page-sequence>
    <!-- Fin du document -->
    </fo:root>
  </xsl:template>

  
  
 <!--
 	Dfinitions gnrales de layout PDF
  -->
  
  <xsl:template name="master-layout">
      <fo:layout-master-set>
      <!-- Premiere page -->
      <fo:simple-page-master master-name="first-page" page-height="29.7cm" page-width="21cm"
                             margin-top="1cm" margin-bottom="1cm" margin-left="1.5cm" margin-right="1.5cm">
           <fo:region-body    column-count="2" margin-left="0cm" margin-top="3.5cm" margin-bottom="4cm"/>
           <fo:region-before region-name="my-header-one" extent="3.5cm"
                             precedence="true" display-align="after"  />
           <fo:region-after  region-name="my-footer-one" extent="4cm" precedence="true" margin-top="0cm" />
      </fo:simple-page-master>

      <fo:simple-page-master master-name="second-page" page-height="29.7cm" page-width="21cm"
                             margin-top="1cm" margin-bottom="1cm" margin-left="1.5cm" margin-right="1.5cm">
           <fo:region-body   column-count="2" margin-left="0cm" margin-top="2.1cm" margin-bottom="1.5cm"/>
           <fo:region-before region-name="my-header-two" extent="1.8cm"
                             precedence="true" display-align="after" />
           <fo:region-after  region-name="my-footer-two" extent="1cm"
                             precedence="true" display-align="after" />
      </fo:simple-page-master>
 
      <fo:simple-page-master master-name="next-pages" page-height="29.7cm" page-width="21cm"
                             margin-top="1cm" margin-bottom="1cm" margin-left="1.5cm" margin-right="1.5cm">
           <fo:region-body   column-count="3" margin-left="0cm" margin-top="2.1cm" margin-bottom="1.5cm"/>
           <fo:region-before region-name="my-header-two" extent="1.8cm"
                             precedence="true" display-align="after" />
           <fo:region-after  region-name="my-footer-two" extent="1cm"
                             precedence="true" display-align="after" />
      </fo:simple-page-master>
      
      <!-- Definition de la sequence -->
      <fo:page-sequence-master master-name="my-sequence">
        <fo:single-page-master-reference master-reference="first-page"/>
        <fo:single-page-master-reference master-reference="second-page"/>
        <fo:repeatable-page-master-reference master-reference="next-pages"/>
      </fo:page-sequence-master>
    </fo:layout-master-set>	
  </xsl:template>

  
  <!--
        Zones Statiques
        ===============
    -->
    
   <xsl:template name="headers">
   
      <!-- 
      	Header de la page #1 
      -->
     <fo:static-content flow-name="my-header-one">
       <!-- logo -->
       <fo:block-container
                        height="2.8cm" width="3.2cm"
                        top="0cm" left="0cm" position="absolute"
                        margin="0pt">
            <fo:block>
            	<fo:external-graphic  width="100%" content-width="scale-to-fit" content-height="2.8cm">
            	  <xsl:attribute name="src">
            	    <xsl:value-of select="$fiche//org/logo/@src"/>
            	  </xsl:attribute>
            	</fo:external-graphic>
            </fo:block>
       </fo:block-container>
       
       <!-- bandeau color -->
       <fo:block-container height="0.5cm" width="18cm"
       			top="3cm" left="0cm" position="absolute" margin="0pt">
       	 <fo:block>
       	         <fo:external-graphic  width="100%" content-width="scale-to-fit" content-height="1cm">
            	  <xsl:attribute name="src">
            	    <xsl:value-of select="$cfBandeau"/>
            	  </xsl:attribute>
            	</fo:external-graphic>
       	 </fo:block>                                                                     
       </fo:block-container>
       
       <!-- signature organisme -->
       <fo:block-container height="2.2cm" width="14.5cm" top="0.5cm" left="3.5cm" position="absolute" margin="3pt">
       		<fo:block text-align="start" font-family="Times" font-size="12pt" font-weight="bold" color="black">
       			<xsl:value-of select="$fiche//org/nom"/>
       		</fo:block>
       		<fo:block text-align="start" font-family="Times" font-size="12pt" color="black">
       			<xsl:value-of select="$fiche//org/description"/>
       		</fo:block>
       		<fo:block text-align="start" font-family="Times" font-size="12pt" color="black">
       			<xsl:value-of select="$fiche//org/adresse"/>
       		</fo:block>
       		<fo:block text-align="start" font-family="Courier" font-size="10pt" color="black"
                 	padding-before="3pt" padding-after="6pt">
                 	<xsl:value-of select="$fiche//org/site"/> - <xsl:value-of select="$fiche//org/email"/>
                 </fo:block>
       </fo:block-container>
     </fo:static-content>
 
     <!--  
     	header des autres pages 
     -->
     <fo:static-content flow-name="my-header-two">
     	<fo:block
             border-bottom-color="blue"
             border-bottom-style="solid"
             border-bottom-width="thin"
             padding-after="4pt"
             font-family="Times" font-size="12pt" font-style="italic"
             color="darkblue">
           <xsl:value-of select="$fiche//espece/titre"/>
         </fo:block>
     </fo:static-content>
     
  </xsl:template>
  
     
  <xsl:template name="footers">
  
  	<!-- Zones statiques : footer  -->
  	<fo:static-content flow-name="my-footer-one">
  		<fo:block-container
                       height="3.5cm" width="18cm" top="0.5cm" left="0cm" position="absolute"
                       border-top-color="blue"  border-top-style="solid" border-top-width="thin"
                       margin="3pt" padding-top="5pt" font-style="italic"
                       >
                     <xsl:apply-templates select="$fiche//org/memo">
                       <xsl:with-param name="fontSize" select="'10pt'"/>
                     </xsl:apply-templates>
                </fo:block-container>
        </fo:static-content>
        
        <!-- zones statiques : footer autres pages -->
        <fo:static-content flow-name="my-footer-two">
        	<fo:block
        		padding-before="6pt" 
        		border-top-color="blue" border-top-style="solid" border-top-width="thin"
        		font-family="Times" font-size="12pt" font-style="italic"
        		text-align="center"
        		color="darkblue">
        	   <xsl:value-of select="$fiche//org/dataset/nom"/>
        	   <xsl:text> - Fiche </xsl:text>
        	    <xsl:value-of select="$fiche//espece/@id"/>
        	   <xsl:text>, extraite le </xsl:text>
        	   <xsl:value-of select="$fiche/collection/@date"/>
        	   <xsl:text> - Page </xsl:text>
        	   <fo:page-number/>
        	 </fo:block>
        </fo:static-content>
        
   </xsl:template> 
 
  <!-- GENERATION d'UNE CARTE STATIQUE -->
  <xsl:template name="carte">    
    <xsl:variable name="mapper">
      <xsl:value-of select="$cfMapperRoot"/>
      <xsl:text>&amp;zoom=</xsl:text><xsl:value-of select="$context/cartographie/zoom"/>
      <xsl:text>&amp;center=</xsl:text><xsl:value-of select="$context/cartographie/latitude"/>
      <xsl:text>,</xsl:text><xsl:value-of select="$context/cartographie/longitude"/>
      <xsl:text>&amp;key=</xsl:text><xsl:value-of select="$context/cartographie/key"/>
      <xsl:value-of select="$cfMapperLarge"/>
      <xsl:value-of select="$cfMapperMarkerData"/>
      <xsl:for-each select="$observations/observations/observation">
        <xsl:if test="position()>1">
        <xsl:text>%7C%7C</xsl:text>
        </xsl:if>
        <xsl:value-of select="adresse/@lat"/>
        <xsl:text>,</xsl:text>
        <xsl:value-of select="adresse/@lng"/>
      </xsl:for-each>
    </xsl:variable>    
    <fo:block  text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="14pt"
                space-before="6pt" space-after="4pt"
                color="blue" keep-with-next="always">
        	  	<xsl:text>Rpartition gographique</xsl:text>
    </fo:block>
    <fo:block space-after="6pt">
      <fo:external-graphic width="100%" src="{$mapper}" content-width="scale-to-fit" content-height="10cm"/>
    </fo:block>    
  </xsl:template> 
  
  <xsl:template match="espece">
     <fo:block
     	margin="0" padding="0"
        font-family="Times" font-size="10pt"
        text-align="center"
        >

        <xsl:apply-templates select="img[@titre='logo']"/>
        <xsl:apply-templates select="texte"/>
        <xsl:apply-templates select="ps"/>
     </fo:block>
  </xsl:template>
 
  <!-- GRAPHIQUE SVG -->
  <xsl:template match="graphique">
    <xsl:param name="title"/>
    <fo:block   	text-align="start" text-indent="0cm"
                	font-family="Times" font-weight="bold" font-size="14pt"
                	space-before="6pt" space-after="4pt"
                	color="blue" keep-with-next="always">
               <xsl:value-of select="$title"/>
    </fo:block>
    <fo:block>
      <fo:instream-foreign-object 
      		content-width="250%" content-height="250%" 
      		width="100%" scaling="uniform">
      		<svg:svg>
      		 <xsl:copy-of select="svg:svg/@viewBox"/>
             <xsl:copy-of select="svg:svg/*"/>
            </svg:svg>
      </fo:instream-foreign-object>
    </fo:block>
  </xsl:template>

  <!-- LISTE DES PHOTOS -->
  <xsl:template name="listePhotos">
      <xsl:if test="$observations/observations/observation">
          <fo:block  text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="14pt"
                space-before="6pt" space-after="4pt"
                color="blue">
        	  	<xsl:text>Photos des observations</xsl:text>
          </fo:block>
          <xsl:apply-templates select="$observations/observations/observation/img"/>
      </xsl:if>
  </xsl:template>  
  
  <!-- LISTE DES OBSERVATIONS -->
  <xsl:template name="listeObservations">
      <xsl:if test="$observations/observations/observation">
          <fo:block  text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="14pt"
                space-before="6pt" space-after="4pt"
                color="blue">
        	  	<xsl:text>Dtail des observations</xsl:text>
          </fo:block>
          <xsl:apply-templates select="$observations/observations/observation" mode="table"/>
          <!--
          <fo:list-block
                   provisional-distance-between-starts="14pt"
                   provisional-label-separation="3pt"
                   text-align="justify"
                   font-family="Times" font-size="11pt"
                   space-before="3pt" space-after="4pt">
        	  <xsl:apply-templates select="$observations/observations/observation" mode="detail"/>
          </fo:list-block>
          -->
      </xsl:if>
  </xsl:template>
  
  <xsl:template match="observation" mode="detail">
     <fo:list-item>
      <fo:list-item-label end-indent="label-end()">
        <fo:block>&#x2022;</fo:block>
      </fo:list-item-label>
      <fo:list-item-body start-indent="body-start()">
        <fo:block font-family="Times" font-size="11pt">
          <xsl:value-of select="date_obs"/><xsl:text> par </xsl:text><xsl:value-of select="observateur"/>
        </fo:block>
        <fo:block font-family="Times" font-size="11pt">
          <xsl:if test="string-length(adresse)">
            <xsl:value-of select="adresse"/><xsl:text>, </xsl:text>
          </xsl:if>
          <xsl:value-of select="commune"/>
        </fo:block>
      </fo:list-item-body>
    </fo:list-item>
     <!--
     <xsl:apply-templates select="img"/>
     -->
  </xsl:template>
  
  <xsl:template match="observation" mode="table">  
    <fo:table table-layout="fixed">
       <fo:table-body>
       <fo:table-row>
           <fo:table-cell>
           		<fo:block>
           		  <xsl:if test="img">
           		    <xsl:apply-templates select="img[1]"/>
           		  </xsl:if>
           		</fo:block>
           	</fo:table-cell>
           	<fo:table-cell>
           	  <fo:block font-family="Times" font-size="9pt" margin-top="16pt" margin-left="6pt" space-before="6pt">
           	    <fo:basic-link external-destination="url({@url})"
                   text-decoration="underline" color="blue"><xsl:text>N </xsl:text><xsl:value-of select="@id"/>
           	    </fo:basic-link>
           	    <xsl:text>, le </xsl:text><xsl:value-of select="date_obs"/>
           	  </fo:block>
           	  <fo:block font-family="Times" font-size="9pt" margin-left="6pt">
           	    <xsl:text>par </xsl:text><xsl:value-of select="observateur"/>
           	  </fo:block>
           	  <xsl:if test="string-length(adresse)">
           	    <fo:block font-family="Times" font-size="9pt" margin-left="6pt">
           	      <xsl:value-of select="adresse"/><xsl:text>, </xsl:text>
           	    </fo:block>
           	  </xsl:if>
           	  <fo:block font-family="Times" font-size="9pt" margin-left="6pt" margin-bottom="16pt" space-after="4pt">
           	    <xsl:value-of select="commune"/>
           	  </fo:block>
            </fo:table-cell>
       </fo:table-row>
       </fo:table-body>
    </fo:table>
  </xsl:template>
  
  <!-- SYNTHESE DES OBSERVATEURS -->  
  <xsl:template name="observateurs">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    
    <xsl:variable name="observateurs">
      <xsl:element name="observateurs">
      <xsl:apply-templates select="$observations/observations/observation[img]/auteur-ref" mode="collect">
        <xsl:sort select="." data-type="text" order="ascending"/>
      </xsl:apply-templates>
      </xsl:element>
    </xsl:variable>
           
    <fo:block  text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="14pt"
                space-before="6pt" space-after="4pt"
                color="blue" keep-with-next="always">   
      <xsl:text>Crdits photographiques</xsl:text>
    </fo:block>
    <fo:list-block
                   provisional-distance-between-starts="14pt"
                   provisional-label-separation="3pt"
                   text-align="justify"
                   font-family="{$fontFamily}" font-size="{$fontSize}"
                   space-before="3pt" space-after="4pt">
          <xsl:for-each select="xalan:nodeset($observateurs)//auteur-ref">
          <xsl:variable name="nom" select="."/>
          <fo:list-item>
            <fo:list-item-label end-indent="label-end()">
              <fo:block>&#x2022;</fo:block>
            </fo:list-item-label>
            <fo:list-item-body start-indent="body-start()">
             <fo:block font-family="{$fontFamily}" font-size="{$fontSize}">
               <xsl:value-of select="."/>
             </fo:block>
            </fo:list-item-body>
          </fo:list-item>
          </xsl:for-each>
    </fo:list-block>
  </xsl:template>  
  
  <!-- Recherches des observateurs uniques -->
  <xsl:template match="auteur-ref" mode="collect">
   <xsl:variable name="eid" select="@id"/>
   <xsl:variable name="me" select="."/>
   <xsl:for-each select="$observations">
     <xsl:if test="generate-id($me)= generate-id(key('observateur',$eid))">
       <xsl:copy-of select="$me"/>
     </xsl:if>
   </xsl:for-each>
  </xsl:template>  
  
  
  <!--
  	Traitement des lments de texte
  -->

  <xsl:template match="img">
    <fo:block padding="5pt">
      <fo:external-graphic src="{@src}" 
      	content-width="scale-to-fit" 
      	content-height="100%" 
      	width="100%" scaling="uniform"/>
    </fo:block>
  </xsl:template>
  
  <xsl:template match="p[@class='citation']">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>

    <fo:block text-align="justify" text-indent="0cm"
              font-family="{$fontFamily}" font-size="{$fontSize}" font-style="italic"
              space-before="3pt" space-after="4pt" color="brown"
              margin-left="0.5cm" margin-right="0.5cm"
              >
     <xsl:apply-templates/>
    </fo:block>
  </xsl:template>
                    	
  <xsl:template match="p">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    
    <fo:block text-align="justify" text-indent="0cm"
              font-family="{$fontFamily}" font-size="{$fontSize}"
              space-before="3pt" space-after="4pt" 
              >
     <xsl:apply-templates/>
    </fo:block>
  </xsl:template>
  
  <xsl:template match="table">
      <fo:table table-layout="fixed">
        <xsl:apply-templates select="thead"/>
        <xsl:choose>
          <xsl:when test="tbody">
            <fo:table-body>
              <xsl:apply-templates select="tbody/tr"/>
            </fo:table-body>
          </xsl:when>
          <xsl:otherwise>
            <fo:table-body>
              <xsl:apply-templates select="tr"/>
            </fo:table-body>
          </xsl:otherwise>
        </xsl:choose>
      </fo:table>
  </xsl:template>


  
  <xsl:template match="thead">
    <fo:table-header>
      <xsl:apply-templates select="tr"/>
    </fo:table-header>
  </xsl:template>
 
  <xsl:template match="tr">
      <fo:table-row>
        <xsl:apply-templates select="td|th"/>
      </fo:table-row>
  </xsl:template>
 
  <xsl:template match="td|th">
      <fo:table-cell>
        <fo:block>
        	<xsl:apply-templates select="*|text()"/>
        </fo:block>
      </fo:table-cell>
  </xsl:template>
  
  <xsl:template match="h2">
    <fo:block   text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="14pt"
                space-before="12pt" space-after="6pt"
                background-color="lightblue">
      <xsl:value-of select="."/>
    </fo:block>
  </xsl:template>

  <xsl:template match="h3">
    <fo:block   text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="12pt"
                space-before="6pt" space-after="4pt"
                color="blue">
      <xsl:value-of select="."/>
    </fo:block>
  </xsl:template>
  

  <xsl:template match="h4">
    <fo:block   text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="11pt"
                space-before="4pt" space-after="4pt"
                >
      <xsl:value-of select="."/>
    </fo:block>
  </xsl:template>
  
  <xsl:template match="hr">
    <fo:block>
      <fo:leader leader-length="100%" leader-pattern="rule" rule-thickness="1pt" color="black"/>
    </fo:block>
  </xsl:template>
  <!--
  <xsl:template match="br">
    <fo:block break-before="line"/>
  </xsl:template>  
  -->
  <xsl:template match="li">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    
    <fo:list-item>
      <fo:list-item-label end-indent="label-end()">
        <fo:block>&#x2022;</fo:block>
      </fo:list-item-label>
      <fo:list-item-body start-indent="body-start()">
        <fo:block font-family="{$fontFamily}" font-size="{$fontSize}"><xsl:apply-templates/></fo:block>
      </fo:list-item-body>
    </fo:list-item>
  </xsl:template>
  
  <xsl:template match="ul">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    
    <fo:list-block
                   provisional-distance-between-starts="14pt"
                   provisional-label-separation="3pt"
                   text-align="justify"
                   font-family="{$fontFamily}" font-size="{$fontSize}"
                   space-before="3pt" space-after="4pt">
    <xsl:apply-templates select="li"/>
    </fo:list-block>
  </xsl:template>

  
  <xsl:template match="b|strong">
    <fo:inline font-weight="bold"><xsl:apply-templates/></fo:inline>
  </xsl:template>
  
  <xsl:template match="i">
    <fo:inline font-style="italic"><xsl:apply-templates/></fo:inline>
  </xsl:template>

  <xsl:template match="u">
    <fo:inline text-decoration="underline"><xsl:apply-templates/></fo:inline>
  </xsl:template>
  
  <xsl:template match="a[@href]">
    <fo:basic-link external-destination="url({@href})"
                   text-decoration="underline" color="blue"><xsl:apply-templates/></fo:basic-link>
  </xsl:template>

  <xsl:template match="text()">
    <xsl:value-of select="."/>
  </xsl:template>
  
 </xsl:stylesheet>
