<?xml version="1.0" encoding="iso-8859-1"?>

<!--
  Fichier    : lieupdf_2.xsl
  Version    : 2
  Cration   : Novembre 2017
  Auteur     : Renaud LAURETTE
  Licence    : GPL v3
  Evolution  : Dcembre 2020 - Compatibilit Biodiv 3.x
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:xalan="http://xml.apache.org/xalan"
                exclude-result-prefixes="xalan"
		version="1.0">

  <!-- Type de sortie -->
  <xsl:output method="xml" version="1.0" encoding="UTF-8"/>
  
  <!-- Parametres d'appel -->
  <xsl:param name="id_lieu" />
  <xsl:param name="avant" />
  <xsl:param name="apres" />
  
  <!-- MAPQUEST -->
  <xsl:variable name="cfMapperRoot" select="'https://www.mapquestapi.com/staticmap/v5/map?type=map'"/> 
  <xsl:variable name="cfMapperSmall" select="'&amp;size=495,250@2x'"/>
  <xsl:variable name="cfMapperLarge" select="'&amp;size=495,600@2x'"/>
  <xsl:variable name="cfMapperMarkerData" select="'&amp;defaultMarker=via-sm-0000ff&amp;locations='"/>
  <xsl:variable name="cfMapperPathData" select="'&amp;shape=border:ff0000ff%7Cweight:1%7Cfill:ff00ff33%7Ccmp%7Cenc:'"/>
  <xsl:variable name="cfMapperPathData2" select="'&amp;shape=cmp%7Cenc:'"/>

  <!-- Variables globales -->
  <xsl:variable name="context" select="/context"/>
  <xsl:variable name="source">
    <xsl:value-of select="$context/server"/>
    <xsl:text>spip.php?page=x_lieu_2&amp;uid=</xsl:text>
    <xsl:value-of select="$id_lieu"/>
    <xsl:text>&amp;apres=</xsl:text>
    <xsl:value-of select="$apres"/>
    <xsl:text>&amp;avant=</xsl:text>
    <xsl:value-of select="$avant"/>
  </xsl:variable>
  <xsl:variable name="collection" select="document($source)"/>
  <xsl:variable name="cfBandeau">
    <xsl:value-of select="$context/server"/>
    <xsl:text>Rsc3/ws/img/bandeau.svg</xsl:text>
  </xsl:variable>
  
  <!-- keys-->
  <xsl:key name="espece" match="espece-ref" use="@id"/>
  <xsl:key name="observateur" match="auteur-ref" use="@id"/>
  <xsl:key name="familier" match="espece" use="famille-ref/@id"/>
  

  
   <!-- especes uniques des observations -->
   <xsl:variable name="espfrag">
     <xsl:element name="especes">
       <xsl:for-each select="$collection//observation/espece-ref">
        <xsl:variable name="eid" select="@id"/>
        <xsl:variable name="me" select="."/>
       	<xsl:if test="generate-id($me)= generate-id(key('espece',$eid))">
         <xsl:variable name="espurl" select="@url"/>
         <xsl:copy-of select="document($espurl)//espece"/>
        </xsl:if>
       </xsl:for-each>
     </xsl:element>
   </xsl:variable>   
   <xsl:variable name="especes" select="xalan:nodeset($espfrag)"/>

   <!-- auteurs uniques des observations -->
   <xsl:variable name="autfrag">
     <xsl:element name="observateurs">
       <xsl:for-each select="$collection//observation/auteur-ref">
        <xsl:variable name="eid" select="@id"/>
        <xsl:variable name="me" select="."/>
       	<xsl:if test="generate-id($me)= generate-id(key('observateur',$eid))">
         <xsl:copy-of select="."/>
        </xsl:if>
       </xsl:for-each>
     </xsl:element>
   </xsl:variable>   
   <xsl:variable name="observateurs" select="xalan:nodeset($autfrag)"/>
   
   <!-- observations avec info famille -->
   <xsl:variable name="obsfrag">
     <xsl:element name="observations">
       <xsl:for-each select="$collection//lieu/observation">
         <xsl:copy>
         	<xsl:copy-of select="*|@*"/>
         	<xsl:if test="espece-ref">
         		<xsl:variable name="fr" select="espece-ref/@id"/>
         		<xsl:copy-of select="$especes//espece[@id=$fr]/famille-ref"/>
         	</xsl:if>	
         </xsl:copy>       
       </xsl:for-each>
     </xsl:element>
   </xsl:variable>   
   <xsl:variable name="observations" select="xalan:nodeset($obsfrag)"/>
      
  <!-- STRUCTURE du DOCUMENT -->
  
  <xsl:template match="/">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
      <xsl:call-template name="master-layout" />
      <fo:page-sequence master-reference="my-sequence">
        <!-- zones statiques -->
        <xsl:call-template name="headers" />
        <xsl:call-template name="footers" />
        <!-- Zone dynamique -->  
        <fo:flow flow-name="xsl-region-body">
              <xsl:if test="$collection//lieu/chapeau">
        	<fo:block 
        		text-align="justify" text-indent="0cm"
        		font-family="Times" font-size="11pt" font-weight="bold"
        		space-before="6pt" space-after="4pt"
        		span="all" >
        	  <xsl:value-of select="$collection//lieu/chapeau"/>
        	 </fo:block>
              </xsl:if>
        	 <fo:block 
        	 	text-align="center" text-indent="0cm"
        	 	font-family="Times" font-size="24pt" color="blue"
        	 	padding-top="25pt" padding-bottom="25pt" span="all"
        	 	 >
        	    <xsl:value-of select="$collection//lieu/titre"/>
        	  </fo:block>
        	  <xsl:call-template name="cartePerimetre"/>
        	  <xsl:apply-templates select="$collection//lieu/texte"/> 
        	  <xsl:apply-templates select="$collection//lieu/notes"/>
        	  <xsl:apply-templates select="$collection//lieu/ps"/>
        	  <xsl:call-template name="synthese"/>
        	  <xsl:call-template name="observateurs"/>
        	  <fo:block   text-align="start" text-indent="0cm"
        	  	font-family="Times" font-weight="bold" font-size="14pt"
        	  	space-before="12pt" space-after="6pt"
        	  	background-color="lightblue"
        	  	break-before="column">
        	  	<xsl:text>Dtail des observations</xsl:text>
        	  </fo:block>
        	  <xsl:apply-templates select="$context/classification/famille" mode="detail"/>

        </fo:flow>
     <!-- Fin des pages -->
     </fo:page-sequence>
    <!-- Fin du document -->
    </fo:root>
  </xsl:template>

  
  
 <!--
 	Dfinitions gnrales de layout PDF
  -->
  
  <xsl:template name="master-layout">
      <fo:layout-master-set>
      <!-- Premiere page -->
      <fo:simple-page-master master-name="first-page" page-height="29.7cm" page-width="21cm"
                             margin-top="1cm" margin-bottom="1cm" margin-left="1.5cm" margin-right="1.5cm">
           <fo:region-body    column-count="2" margin-left="0cm" margin-top="3.5cm" margin-bottom="4cm"/>
           <fo:region-before region-name="my-header-one" extent="3.5cm"
                             precedence="true" display-align="after"  />
           <fo:region-after  region-name="my-footer-one" extent="4cm" precedence="true" margin-top="0cm" />
      </fo:simple-page-master>

      <fo:simple-page-master master-name="all-pages" page-height="29.7cm" page-width="21cm"
                             margin-top="1cm" margin-bottom="1cm" margin-left="1.5cm" margin-right="1.5cm">
           <fo:region-body   column-count="2" margin-left="0cm" margin-top="2.1cm" margin-bottom="1.5cm"/>
           <fo:region-before region-name="my-header-two" extent="1.8cm"
                             precedence="true" display-align="after" />
           <fo:region-after  region-name="my-footer-two" extent="1cm"
                             precedence="true" display-align="after" />
      </fo:simple-page-master>
      
      
      <!-- Definition de la sequence -->
      <fo:page-sequence-master master-name="my-sequence">
        <fo:single-page-master-reference master-reference="first-page"/>
        <fo:repeatable-page-master-reference master-reference="all-pages"/>
      </fo:page-sequence-master>
    </fo:layout-master-set>	
  </xsl:template>

  
  <!--
        Zones Statiques
        ===============
    -->
    
   <xsl:template name="headers">
   
      <!-- 
      	Header de la page #1 
      -->
     <fo:static-content flow-name="my-header-one">
       <!-- logo -->
       <fo:block-container
                        height="2.8cm" width="3.2cm"
                        top="0cm" left="0cm" position="absolute"
                        margin="0pt">
            <fo:block>
            	<fo:external-graphic  width="100%" content-width="scale-to-fit" content-height="2.8cm">
            	  <xsl:attribute name="src">
            	    <xsl:value-of select="$collection//org/logo/@src"/>
            	  </xsl:attribute>
            	</fo:external-graphic>
            </fo:block>
       </fo:block-container>
       
       <!-- bandeau color -->
       <fo:block-container height="0.5cm" width="18cm"
       			top="3cm" left="0cm" position="absolute" margin="0pt">
       	 <fo:block>
       	         <fo:external-graphic  width="100%" content-width="scale-to-fit" content-height="1cm">
            	  <xsl:attribute name="src">
            	    <xsl:value-of select="$cfBandeau"/>
            	  </xsl:attribute>
            	</fo:external-graphic>
       	 </fo:block>                                                                     
       </fo:block-container>
       
       <!-- signature organisme -->
       <fo:block-container height="2.2cm" width="14.5cm" top="0.5cm" left="3.5cm" position="absolute" margin="3pt">
       		<fo:block text-align="start" font-family="Times" font-size="12pt" font-weight="bold" color="black">
       			<xsl:value-of select="$collection//org/nom"/>
       		</fo:block>
       		<fo:block text-align="start" font-family="Times" font-size="12pt" color="black">
       			<xsl:value-of select="$collection//org/description"/>
       		</fo:block>
       		<fo:block text-align="start" font-family="Times" font-size="12pt" color="black">
       			<xsl:value-of select="$collection//org/adresse"/>
       		</fo:block>
       		<fo:block text-align="start" font-family="Courier" font-size="10pt" color="black"
                 	padding-before="3pt" padding-after="6pt">
                 	<xsl:value-of select="$collection//org/site"/> - <xsl:value-of select="$collection//org/email"/>
                 </fo:block>
       </fo:block-container>
     </fo:static-content>
 
     <!--  
     	header des autres pages 
     -->
     <fo:static-content flow-name="my-header-two">
     	<fo:block
             border-bottom-color="blue"
             border-bottom-style="solid"
             border-bottom-width="thin"
             padding-after="4pt"
             font-family="Times" font-size="12pt" font-style="italic"
             color="darkblue">
           <xsl:value-of select="$collection//lieu/titre"/>
         </fo:block>
     </fo:static-content>
     
  </xsl:template>
  
     
  <xsl:template name="footers">
  
  	<!-- Zones statiques : footer  -->
  	<fo:static-content flow-name="my-footer-one">
  		<fo:block-container
                       height="3.5cm" width="18cm" top="0.5cm" left="0cm" position="absolute"
                       border-top-color="blue"  border-top-style="solid" border-top-width="thin"
                       margin="3pt" padding-top="5pt" font-style="italic"
                       >
                     <xsl:apply-templates select="$collection//org/memo">
                       <xsl:with-param name="fontSize" select="'10pt'"/>
                     </xsl:apply-templates>
                </fo:block-container>
        </fo:static-content>
        
        <!-- zones statiques : footer autres pages -->
        <fo:static-content flow-name="my-footer-two">
        	<fo:block
        		padding-before="6pt" 
        		border-top-color="blue" border-top-style="solid" border-top-width="thin"
        		font-family="Times" font-size="12pt" font-style="italic"
        		text-align="center"
        		color="darkblue">
        	   <xsl:value-of select="$collection//org/dataset/nom"/>
        	   <xsl:text> - Lieu </xsl:text>
        	   <xsl:value-of select="$collection/lieu/@id"/>
         	   <xsl:text> (du </xsl:text>
        	   <xsl:value-of select="$apres"/>  
        	   <xsl:text> au </xsl:text>
        	   <xsl:value-of select="$avant"/>
        	   <xsl:text>) extrait le </xsl:text>
        	   <xsl:value-of select="$collection/collection/@date"/>
        	   <xsl:text> - Page </xsl:text>
        	   <fo:page-number/>
        	 </fo:block>
        </fo:static-content>
        
   </xsl:template> 
  
   <!-- SYNTHESE DES OBSERVATIONS -->
   
  <xsl:template name="synthese">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>

    <fo:block   text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="14pt"
                space-before="12pt" space-after="6pt"
                background-color="lightblue"
                break-before="column">
      <xsl:text>Synthse des observations</xsl:text>
    </fo:block>

    <fo:block text-align="justify" text-indent="0cm"
              font-family="{$fontFamily}" font-size="{$fontSize}"
              space-before="3pt" space-after="4pt" 
              >
     <xsl:text>Dans ce secteur, </xsl:text>
     <xsl:value-of select="count($observations/observations/observation)"/>
     <xsl:text> observations ont t enregistres entre le </xsl:text>
     <xsl:value-of select="$apres"/>
     <xsl:text> et le </xsl:text>
     <xsl:value-of select="$avant"/>
     <xsl:text>, parmi lesquelles :</xsl:text>
    </fo:block>  
    <fo:list-block
                   provisional-distance-between-starts="14pt"
                   provisional-label-separation="3pt"
                   text-align="justify"
                   font-family="{$fontFamily}" font-size="{$fontSize}"
                   space-before="3pt" space-after="4pt">
        <xsl:apply-templates select="$context/classification/famille" mode="synthese">
        </xsl:apply-templates>
    </fo:list-block>
  </xsl:template>
    
   <!-- SYNTHESE DES OBSERVATEURS -->
   
  <xsl:template name="observateurs">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    
    <fo:block   text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="14pt"
                space-before="12pt" space-after="6pt"
                background-color="lightblue"
                >
      <xsl:text>Observateurs</xsl:text>
    </fo:block>
    <fo:list-block
                   provisional-distance-between-starts="14pt"
                   provisional-label-separation="3pt"
                   text-align="justify"
                   font-family="{$fontFamily}" font-size="{$fontSize}"
                   space-before="3pt" space-after="4pt">
          <xsl:for-each select="$observateurs//auteur-ref">
          <xsl:sort select="." data-type="text" order="ascending"/>
          <xsl:variable name="nom" select="."/>
          <fo:list-item>
            <fo:list-item-label end-indent="label-end()">
              <fo:block>&#x2022;</fo:block>
            </fo:list-item-label>
            <fo:list-item-body start-indent="body-start()">
             <fo:block font-family="{$fontFamily}" font-size="{$fontSize}">
               <xsl:value-of select="."/><xsl:text> : </xsl:text>
               <xsl:value-of select="count($observations//observation[auteur-ref=$nom])"/>
             </fo:block>
            </fo:list-item-body>
          </fo:list-item>
          </xsl:for-each>
    </fo:list-block>
  </xsl:template>  
 

  
  <!-- Synthese des familles -->
  <xsl:template match="famille" mode="synthese">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    <xsl:variable name="fid" select="@id"/>

    <fo:list-item>
      <fo:list-item-label end-indent="label-end()">
        <fo:block>&#x2022;</fo:block>
      </fo:list-item-label>
      <fo:list-item-body start-indent="body-start()">
        <fo:block font-family="{$fontFamily}" font-size="{$fontSize}">
          <xsl:value-of select="@titre"/>
          <xsl:text> : </xsl:text>
          <xsl:value-of select="count($observations//observation[famille-ref/@id=$fid])"/>
        </fo:block>
      </fo:list-item-body>
    </fo:list-item>
  </xsl:template> 
   
  <!-- GENERATION d'UNE CARTE STATIQUE -->
  <xsl:template name="carte">
    <xsl:param name="fid" select="''"/>
    <xsl:param name="eid" select="''"/>
    
    <xsl:variable name="mapper">
      <xsl:value-of select="$cfMapperRoot"/>
      <xsl:text>&amp;zoom=</xsl:text><xsl:value-of select="$context/cartographie/zoom"/>
      <xsl:text>&amp;center=</xsl:text><xsl:value-of select="$context/cartographie/latitude"/>
      <xsl:text>,</xsl:text><xsl:value-of select="$context/cartographie/longitude"/>
      <xsl:text>&amp;key=</xsl:text><xsl:value-of select="$context/cartographie/key"/>
      <xsl:value-of select="$cfMapperLarge"/>
      <xsl:value-of select="$cfMapperMarkerData"/>
      <xsl:choose>
        <xsl:when test="string-length($fid) !=0">
            <xsl:for-each select="$observations//observation[famille-ref/@id=$fid]">
            	<xsl:if test="position()>1">
            		<xsl:text>%7C%7C</xsl:text>
            	</xsl:if>
            	<xsl:value-of select="adresse/@lat"/>
            	<xsl:text>,</xsl:text>
            	<xsl:value-of select="adresse/@lng"/>
        	</xsl:for-each>
        </xsl:when>
        <xsl:when test="string-length($eid) !=0">
            <xsl:for-each select="$observations//observation[espece-ref/@id=$eid]">
            	<xsl:if test="position()>1">
            		<xsl:text>%7C%7C</xsl:text>
            	</xsl:if>
            	<xsl:value-of select="adresse/@lat"/>
            	<xsl:text>,</xsl:text>
            	<xsl:value-of select="adresse/@lng"/>
        	</xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
        	<xsl:for-each select="$observations//observation">
        		<xsl:if test="position()>1">
        			<xsl:text>%7C%7C</xsl:text>
        		</xsl:if>
        		<xsl:value-of select="adresse/@lat"/>
        		<xsl:text>,</xsl:text>
        		<xsl:value-of select="adresse/@lng"/>
        	</xsl:for-each>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <fo:block space-after="6pt">
      <fo:external-graphic width="100%" src="{$mapper}" content-width="scale-to-fit" content-height="12.5cm"/>
    </fo:block>    
  </xsl:template> 
 
   <!-- GENERATION d'UNE CARTE STATIQUE POUR LE PERIMETRE DU LIEU -->
  <xsl:template name="cartePerimetre">
    
    <xsl:variable name="mapper">
      <xsl:value-of select="$cfMapperRoot"/>
      <xsl:text>&amp;zoom=</xsl:text><xsl:value-of select="$context/cartographie/zoom"/>
      <xsl:text>&amp;center=</xsl:text><xsl:value-of select="$context/cartographie/latitude"/>
      <xsl:text>,</xsl:text><xsl:value-of select="$context/cartographie/longitude"/>
      <xsl:text>&amp;key=</xsl:text><xsl:value-of select="$context/cartographie/key"/>
      <xsl:value-of select="$cfMapperLarge"/>
      <xsl:value-of select="$cfMapperPathData2"/><xsl:value-of select="$collection//lieu/polygone/@mpq"/>
    </xsl:variable>
    
    <fo:block   text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="14pt"
                space-before="12pt" space-after="6pt"
                background-color="lightblue"
                >
      <xsl:text>Prsentation du lieu</xsl:text>
    </fo:block>   
    <fo:block space-after="6pt">
      <fo:external-graphic width="100%" src="{$mapper}" content-width="8.5cm" content-height="scale-to-fit"/>
    </fo:block>  
 
  </xsl:template> 
 
 
  <!-- DETAILS PAR FAMILLE -->
  
  <xsl:template match="famille" mode="detail">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    <xsl:variable name="fid" select="@id"/>
    
    <!-- nom de la famille -->
    <fo:block   text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="14pt"
                space-before="12pt" space-after="6pt">
                <!--  background-color="lightblue" break-before="column" -->
      <xsl:value-of select="@titre"/>
    </fo:block>  
    <xsl:choose>
      <xsl:when test="famille">
        <xsl:for-each select="famille">
          <fo:block   	text-align="start" text-indent="0cm"
                	font-family="Times" font-weight="bold" font-size="12pt"
                	space-before="6pt" space-after="4pt"
                	color="blue">
                <xsl:value-of select="@titre"/>
          </fo:block> 
          <xsl:call-template name="detail-famille">
            <xsl:with-param name="fid" select="@id"/>
          </xsl:call-template>          
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="detail-famille">
          <xsl:with-param name="fid" select="$fid"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
    
    
  <xsl:template name="detail-famille">
    <xsl:param name="fid" />
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>

    
    <xsl:choose>
      <xsl:when test="$observations//observation[famille-ref/@id=$fid]">
    <!-- description de la famille -->
    <!-- relicat synthse dtaille
    <xsl:call-template name="carte">
      <xsl:with-param name="fid" select="$fid"/>
    </xsl:call-template>
    -->
    <!-- liste des espces de la famille -->
 
    <fo:list-block
                   provisional-distance-between-starts="14pt"
                   provisional-label-separation="3pt"
                   text-align="justify"
                   font-family="{$fontFamily}" font-size="{$fontSize}"
                   space-before="3pt" space-after="4pt">
        <xsl:apply-templates select="$observations//observation[famille-ref/@id=$fid]" mode="list">
        	<xsl:sort select="espece-ref" data-type="text" order="ascending"/>
        </xsl:apply-templates>
    </fo:list-block>  
     </xsl:when>
     <xsl:otherwise>
         <fo:block text-align="justify" text-indent="0cm"
              font-family="{$fontFamily}" font-size="{$fontSize}"
              space-before="3pt" space-after="4pt" 
              >
       <xsl:text>Aucune espce n'a t observe dans ce groupe.</xsl:text>
    </fo:block> 
     </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template match="observation" mode="list">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    <xsl:variable name="me" select="espece-ref"/>
    <xsl:variable name="eid" select="espece-ref/@id" />
    
    <xsl:for-each select="$observations">
     <xsl:if test="generate-id($me)= generate-id(key('espece',$eid))">
    <fo:list-item>
      <fo:list-item-label end-indent="label-end()">
        <fo:block>&#x2022;</fo:block>
      </fo:list-item-label>
      <fo:list-item-body start-indent="body-start()">
        <fo:block font-family="{$fontFamily}" font-size="{$fontSize}">
          <xsl:value-of select="$me/nom"/>
          <xsl:text> (</xsl:text>
          <xsl:value-of select="$me/nom/@latin"/>
          <xsl:text>)</xsl:text>
        </fo:block>
      </fo:list-item-body>
    </fo:list-item>
    </xsl:if>
    </xsl:for-each>
  </xsl:template> 

  
  <!--
  	Parties de l'article
  -->
  
  <xsl:template match="texte">
    <xsl:apply-templates/>
  </xsl:template>
  
  <xsl:template match="notes">
    <fo:block   text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="11pt"
                space-before="4pt" space-after="4pt"
                >
      <xsl:text>Notes</xsl:text>
    </fo:block>
    <xsl:apply-templates/>
  </xsl:template>
  
  <xsl:template match="ps">
    <fo:block   text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="11pt"
                space-before="4pt" space-after="4pt"
                >
      <xsl:text>Complments</xsl:text>
    </fo:block>
    <xsl:apply-templates/>
  </xsl:template>

  <!--
  	Traitement des lments de texte
  -->
                    	
  <xsl:template match="dl">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    
    <fo:block text-align="justify" text-indent="0cm"
              font-family="{$fontFamily}" font-size="{$fontSize}"
              space-before="6pt" space-after="6pt" 
              >
     <xsl:apply-templates/>
    </fo:block>
  </xsl:template>
  
  <xsl:template match="dt|dd">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    
    <fo:block text-align="justify" text-indent="0cm"
              font-family="{$fontFamily}" font-size="{$fontSize}"
              space-before="2pt" space-after="2pt" 
              >
     <xsl:apply-templates>
       <xsl:with-param name="contexte" select="'dl'"/>
     </xsl:apply-templates>
    </fo:block>
  </xsl:template>  
  
  <xsl:template match="img">
    <xsl:param name="contexte">principal</xsl:param>
    <xsl:choose>
      <xsl:when test="starts-with($contexte,'dl')">
        <fo:external-graphic src="{@src}" width="100%" content-width="8.5cm" content-height="scale-to-fit"/>
      </xsl:when>
      <xsl:otherwise>
       <fo:block space-after="6pt">
         <fo:external-graphic src="{@src}" width="100%" content-width="8.5cm" content-height="scale-to-fit"/>
       </fo:block>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>
			
  <xsl:template match="p[@class='citation']">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>

    <fo:block text-align="justify" text-indent="0cm"
              font-family="{$fontFamily}" font-size="{$fontSize}" font-style="italic"
              space-before="3pt" space-after="4pt" color="brown"
              margin-left="0.5cm" margin-right="0.5cm"
              >
     <xsl:apply-templates/>
    </fo:block>
  </xsl:template>
                    	
  <xsl:template match="p">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    
    <fo:block text-align="justify" text-indent="0cm"
              font-family="{$fontFamily}" font-size="{$fontSize}"
              space-before="3pt" space-after="4pt" 
              >
     <xsl:apply-templates/>
    </fo:block>
  </xsl:template>

  <xsl:template match="h2">
    <fo:block   text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="14pt"
                space-before="12pt" space-after="6pt"
                background-color="lightblue">
      <xsl:value-of select="."/>
    </fo:block>
  </xsl:template>

  <xsl:template match="h3">
    <fo:block   text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="12pt"
                space-before="6pt" space-after="4pt"
                color="blue">
      <xsl:value-of select="."/>
    </fo:block>
  </xsl:template>
  

  <xsl:template match="h4">
    <fo:block   text-align="start" text-indent="0cm"
                font-family="Times" font-weight="bold" font-size="11pt"
                space-before="4pt" space-after="4pt"
                >
      <xsl:value-of select="."/>
    </fo:block>
  </xsl:template>
  
  <xsl:template match="hr">
    <fo:block>
      <fo:leader leader-length="100%" leader-pattern="rule" rule-thickness="1pt" color="black"/>
    </fo:block>
  </xsl:template>
  <!--
  <xsl:template match="br">
    <fo:block break-before="line"/>
  </xsl:template>  
  -->
  <xsl:template match="li">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    
    <fo:list-item>
      <fo:list-item-label end-indent="label-end()">
        <fo:block>&#x2022;</fo:block>
      </fo:list-item-label>
      <fo:list-item-body start-indent="body-start()">
        <fo:block font-family="{$fontFamily}" font-size="{$fontSize}"><xsl:apply-templates/></fo:block>
      </fo:list-item-body>
    </fo:list-item>
  </xsl:template>
  
  <xsl:template match="ul">
    <xsl:param name="fontFamily">Times</xsl:param>
    <xsl:param name="fontSize">11pt</xsl:param>
    
    <fo:list-block
                   provisional-distance-between-starts="14pt"
                   provisional-label-separation="3pt"
                   text-align="justify"
                   font-family="{$fontFamily}" font-size="{$fontSize}"
                   space-before="3pt" space-after="4pt">
    <xsl:apply-templates select="li"/>
    </fo:list-block>
  </xsl:template>

  
  <xsl:template match="b|strong">
    <fo:inline font-weight="bold"><xsl:apply-templates/></fo:inline>
  </xsl:template>
  
  <xsl:template match="i">
    <fo:inline font-style="italic"><xsl:apply-templates/></fo:inline>
  </xsl:template>

  <xsl:template match="u">
    <fo:inline text-decoration="underline"><xsl:apply-templates/></fo:inline>
  </xsl:template>
  
  <xsl:template match="a[@href]">
    <fo:basic-link external-destination="url({@href})"
                   text-decoration="underline" color="blue"><xsl:apply-templates/></fo:basic-link>
  </xsl:template>

  <xsl:template match="text()">
    <xsl:value-of select="."/>
  </xsl:template>
  
 </xsl:stylesheet>
