<?php
/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         ddi  la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a t dvelopp initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu sous licence GNU/GPL.         *
 *  Pour plus de dtails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/



include_spip("inc/autoriser");


function formulaires_illustrer_auteur_charger($redirect='') {
	// Initialisation du formulaire
	$valeurs = array(
		'id_auteur' => intval(session_get('id_auteur'))	// identifiant de l'auteur
	);	
	return $valeurs;
}



function formulaires_illustrer_auteur_verifier($redirect='') {
	include_spip('inc/acces');
	include_spip('inc/texte');
	include_spip('inc/forum');
	include_spip('inc/session');
	include_spip('base/abstract_sql');

	$erreurs = array();
	$id_auteur = intval(session_get('id_auteur'));
			
	// vrifier les fichier transmis
	$upload_dir = _DIR_TMP . "upload/";
	$fieldName="logoaut";
	$pbs=""; $nofile = true;
	foreach($_POST as $key => $value) {
		if(strncmp($key,$fieldName,strlen($fieldName))==0) {
			$img = $_POST[$key];
			$img = str_replace('data:image/jpeg;base64,', '', $img);
			$img = str_replace(' ', '+', $img);
			$data = base64_decode($img);
			$file = $upload_dir . "a$id_auteur". $key . ".jpg";
			$success = file_put_contents($file, $data);
			if($success) {
				$nofile= false;
			} else {
				$pbs .= "$key ";
			}
		}
	}
	
	if(strlen($pbs) !=0) 
		$erreurs['message_erreur'] = _T('biodiv:echec_telechargement'). " $pbs";
	
	if($nofile)
		$erreurs['message_erreur'] = _T('biodiv:aucun_fichier');
	
	return $erreurs;
}

function formulaires_illustrer_auteur_traiter($redirect='') {	
	$id_auteur = intval(session_get('id_auteur'));
	$upload_dir = _DIR_TMP . "upload/";
	$target_dir = _DIR_IMG;
	$fieldName="logoaut";
	
	foreach($_POST as $key => $value) {
		if(strncmp($key,$fieldName,strlen($fieldName))==0) {
			$file = $upload_dir . "a$id_auteur". $key . ".jpg";
			$cible = $target_dir. "auton$id_auteur.jpg";
			rename($file,$cible);
		}
	}
	$resultat = array(
		'message_ok' => _T('biodiv:telechargement_reussi'),
		'redirect' => $redirect,
		);				
	return $resultat;
}


?>
