<?php
/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         dédié à la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a été développé initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.         *
 *  Pour plus de détails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/


include_spip('inc/actions');
include_spip('inc/editer');

//
// Fonction CVT
//

function formulaires_rechercher_lieu_charger()
{	
	// On crée le dossier _DIR_BIODIV_TMP_LIEUX si besoin
	// et on le nettoie des fichiers ayant plus de 24h
	$repertoire = _DIR_BIODIV_TMP_LIEUX;
	if(!file_exists($repertoire)) {
		mkdir($repertoire);
	} else {
		$contenu = array_diff(scandir($repertoire),array(".",".."));
		foreach($contenu as $entry) {
			$file = $repertoire . '/' . $entry;
			$stat = stat($file);
			if($stat['mtime'] < time() - (24*60*60)) unlink($file);
		}
	}	
	// Pas d'initialisation spécifique
	$valeurs = array();
	return $valeurs;
	
}

function formulaires_rechercher_lieu_verifier()
{
	$erreurs = array();	
	return $erreurs;
}

function formulaires_rechercher_lieu_traiter()
{

	$resultat = array();
	
	// On récupère l'objet GeoJSON
	$lieu_geo = json_decode(_request('dumpy'));
	
	// On ajoute les propriétés issues du formulaire ...
	$lieu_geo->properties->titre = 'Formulaire de recherche';
	$lieu_geo->properties->id_auteur = _request('id_auteur');
	
	// .. et quelques infos locales
	$lieu_geo->properties->date = date('Y-m-d H:i:s');
	$lieu_geo->properties->server['server'] = $_SERVER['SERVER_NAME'];
	$lieu_geo->properties->server['referer'] = $_SERVER['HTTP_REFERER'];
	$lieu_geo->properties->server['origin'] = $_SERVER['REMOTE_ADDR'];
	
	// On construit la bounding box
	$polygon = $lieu_geo->geometry->coordinates[0];
	$minlng = 180; $maxlng=-180;
	$minlat=90; $maxlat =-90;
	foreach($polygon as $vertex) {
		$minlng = ($minlng > $vertex[0]) ? $vertex[0] : $minlng;
		$minlat = ($minlat > $vertex[1]) ? $vertex[1] : $minlat;
		$maxlng = ($maxlng < $vertex[0]) ? $vertex[0] : $maxlng;
		$maxlat = ($maxlat < $vertex[1]) ? $vertex[1] : $maxlat;
	}
	$lieu_geo->bbox = array($minlng, $minlat, $maxlng, $maxlat);
	
	// on génère le fichier
	// Celui-ci sera écrasé à chaque appel du même utilisateur
	$repertoire = _DIR_TMP;
	$fname = md5("recherche-lieu" .time());
	$file = _DIR_BIODIV_TMP_LIEUX . $fname; 

	$fp = fopen($file,"w");
	if($fp) {
		// ecrire le fichier
		fwrite($fp,json_encode($lieu_geo));
		fclose($fp);
		$resultat['message_ok'] = $lieu_geo->properties->titre;
		// Le prefixe 't|' devant le nom de fichier permet de repérer les
		// fichiers temporaraires pour aller les chercher dans le bon répertoire
		$resultat['redirect'] = generer_url_public('lieu_resultat',array('perimetre'=> "t|$fname"),false, false);
	} else {
		$resultat['message_erreur'] = "Echec de la création du périmètre : ". $lieu_geo->properties->titre;
	}

	// On retourne le résultat
	return $resultat;
}

?>
