<?php
/**
 * Utilisation de l'action supprimer pour l'objet observation
 *
 * @plugin     Biodiv
 * @copyright  2020
 * @author     Renaud LAURETTE
 * @licence    GNU/GPL
 * @package    SPIP\Biodiv\Action
 */

if (!defined('_ECRIRE_INC_VERSION')) {
	return;
}



/**
 * Action pour supprimer un·e observation
 *
 * Vérifier l'autorisation avant d'appeler l'action.
 *
 * @example
 *     ```
 *     [(#AUTORISER{supprimer, observation, #ID_OBSERVATION}|oui)
 *         [(#BOUTON_ACTION{<:observation:supprimer_observation:>,
 *             #URL_ACTION_AUTEUR{supprimer_observation, #ID_OBSERVATION, #URL_ECRIRE{biodiv_observations}},
 *             danger, <:observation:confirmer_supprimer_observation:>})]
 *     ]
 *     ```
 *
 * @example
 *     ```
 *     [(#AUTORISER{supprimer, observation, #ID_OBSERVATION}|oui)
 *         [(#BOUTON_ACTION{
 *             [(#CHEMIN_IMAGE{observation-del-24.png}|balise_img{<:observation:supprimer_observation:>}|concat{' ',#VAL{<:observation:supprimer_observation:>}|wrap{<b>}}|trim)],
 *             #URL_ACTION_AUTEUR{supprimer_observation, #ID_OBSERVATION, #URL_ECRIRE{biodiv_observations}},
 *             icone s24 horizontale danger observation-del-24, <:observation:confirmer_supprimer_observation:>})]
 *     ]
 *     ```
 *
 * @example
 *     ```
 *     if (autoriser('supprimer', 'observation', $id_observation)) {
 *          $supprimer_observation = charger_fonction('supprimer_observation', 'action');
 *          $supprimer_observation($id_observation);
 *     }
 *     ```
 *
 * @param null|int $arg
 *     Identifiant à supprimer.
 *     En absence de id utilise l'argument de l'action sécurisée.
**/
function action_supprimer_observation_dist($arg=null) {
	if (is_null($arg)){
		$securiser_action = charger_fonction('securiser_action', 'inc');
		$arg = $securiser_action();
	}
	$arg = intval($arg);

	// cas suppression
	if ($arg) {
		sql_delete('spip_biodiv_observations',  'id_observation=' . sql_quote($arg));
	}
	else {
		spip_log("action_supprimer_observation_dist $arg pas compris");
	}
}
