<?php
/**
 * Utilisation de l'action supprimer pour l'objet source
 *
 * @plugin     Biodiv
 * @copyright  2020
 * @author     Renaud LAURETTE
 * @licence    GNU/GPL
 * @package    SPIP\Biodiv\Action
 */

if (!defined('_ECRIRE_INC_VERSION')) {
	return;
}



/**
 * Action pour supprimer un·e source
 *
 * Vérifier l'autorisation avant d'appeler l'action.
 *
 * @example
 *     ```
 *     [(#AUTORISER{supprimer, source, #ID_SOURCE}|oui)
 *         [(#BOUTON_ACTION{<:source:supprimer_source:>,
 *             #URL_ACTION_AUTEUR{supprimer_source, #ID_SOURCE, #URL_ECRIRE{biodiv_sources}},
 *             danger, <:source:confirmer_supprimer_source:>})]
 *     ]
 *     ```
 *
 * @example
 *     ```
 *     [(#AUTORISER{supprimer, source, #ID_SOURCE}|oui)
 *         [(#BOUTON_ACTION{
 *             [(#CHEMIN_IMAGE{source-del-24.png}|balise_img{<:source:supprimer_source:>}|concat{' ',#VAL{<:source:supprimer_source:>}|wrap{<b>}}|trim)],
 *             #URL_ACTION_AUTEUR{supprimer_source, #ID_SOURCE, #URL_ECRIRE{biodiv_sources}},
 *             icone s24 horizontale danger source-del-24, <:source:confirmer_supprimer_source:>})]
 *     ]
 *     ```
 *
 * @example
 *     ```
 *     if (autoriser('supprimer', 'source', $id_source)) {
 *          $supprimer_source = charger_fonction('supprimer_source', 'action');
 *          $supprimer_source($id_source);
 *     }
 *     ```
 *
 * @param null|int $arg
 *     Identifiant à supprimer.
 *     En absence de id utilise l'argument de l'action sécurisée.
**/
function action_supprimer_source_dist($arg=null) {
	if (is_null($arg)){
		$securiser_action = charger_fonction('securiser_action', 'inc');
		$arg = $securiser_action();
	}
	$arg = intval($arg);

	// cas suppression
	if ($arg) {
		sql_delete('spip_biodiv_sources',  'id_source=' . sql_quote($arg));
	}
	else {
		spip_log("action_supprimer_source_dist $arg pas compris");
	}
}
