<?php
/**
 * Définition des initialisations spécifiques à Biodiv
 *
 * @plugin     Biodiv
 * @copyright  2024
 * @author     Renaud LAURETTE
 * @licence    GNU/GPL
 * @package    SPIP\Biodiv\Installation
 */

 
 /**
  * Types de documents
  */
  
function biodiv_types_specifiques() {
  return array(
  	  
  	array(	// Définition de lieux Biodiv (GeoJSON restreint)
  		'extension' => 'lieu',
  		'mime_type' => 'application/json',
  		'titre' 	=> 'Lieu Biodiv',
  		'inclus' 	=> 'non',
  		'upload' 	=> 'oui'
  		),
  	
  	array(	// Fichiers GeoJSON
  	  	'extension' =>'geojson',
  		'mime_type' => 'application/json',
  		'titre'	 	=> 'GeoJSON',
  		'inclus' 	=> 'non',
  		'upload' 	=> 'oui'
  		),
  	
  	array(	// Requêtes persistantes
  	  	'extension' =>'requete',
  		'mime_type' => 'application/json',
  		'titre' 	=> 'Requête Biodiv',
  		'inclus' 	=> 'non',
  		'upload' 	=> 'oui'
  		),
  	
  	);
}

/**
 * Sous répertoires de _TMP à créer
 */
 
function biodiv_repertoires_tmp() {
	return array(
		'upload',	// Téléchargements FTP
		'lieux',	// Lieux temporaires
		'requetes'	// Requêtes temporaires de recherche d'observations
		);
}

?>