<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         dédié à la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2025 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a été développé initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : https://apcveb.fr/                                        *
 *                                                                             *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.         *
 *  Pour plus de détails voir les fichiers COPYING.txt et LICENCE-BIODIV.md    *
\*******************************************************************************/


if (!defined('_ECRIRE_INC_VERSION')) return;

// Passer cette constante à true pour afficher les liens problématiques
// avant que le nettoyage ait lieu.
define('_BIOCLEAN_VERBOSE', false);

/**
 * Fonction principale de nettoyage
 *
 * @param int $t
 * @return int
 */
 
function genie_bioclean_dist($t) {
	
	if(_BIOCLEAN_VERBOSE)
		spip_log("BIOCLEAN ------ ", "biodiv."._LOG_INFO_IMPORTANTE);
	
	nettoyer_liens_observation_famille();
	nettoyer_liens_observation_espece();
	return(1);
}

/**
 * Elimination des liens observation-famille
 * pour les familles non publiées ou absentes
 */
 
function nettoyer_liens_observation_famille() {
	
	// identifier toutes les rubriques publiées
	$ids = sql_get_select('id_rubrique', 'spip_rubriques', array("statut='publie'"));
	// Les liens a problème sont ceux dont l'id_famille ne correspond à aucune famille publiée
	// c'est à dire ceux dont la valeur absolue ne correspond à aucun id de rubrique. En effet,
	// les observations inclassables sont liées à une rubrique par l'opposé de l'id_rubrique
	// Voir squelettes/formulaires/delier_famille.php
	
	if(_BIOCLEAN_VERBOSE) {
		$resultats = sql_select(
			array('id_observation','id_famille'),
			'spip_biodiv_observations',
			array("ABS(id_famille) NOT IN ($ids)", "id_famille != 0")
			);
	
		while ($res = sql_fetch($resultats)) {
			spip_log("BIOCLEAN obs-fam ".$res['id_observation']." ".$res['id_famille'], "biodiv."._LOG_INFO_IMPORTANTE);
		}
	}
	
	sql_updateq(
		'spip_biodiv_observations',
		array("id_famille" => 0),
		array("ABS(id_famille) NOT IN ($ids)", "id_famille != 0")
		);
}

/**
 * Elimination des liens observation-espece
 * pour les especes non publiées ou absentes
 */
function nettoyer_liens_observation_espece() {
	
	// identifier toutes les especes publiées
	$ids = sql_get_select('id_article', 'spip_articles', array("composition='espece'","statut='publie'"));
	// Les liens à problème sont ceux où id_espece ne correspond à aucun article-espece
	// Il faut toutefois garder les id_espece = -1 qui concernent les observations inclassables
	// On ne considère donc que les id_espece > 0

	if(_BIOCLEAN_VERBOSE) {
		$resultats = sql_select(
			array('id_observation','id_espece'),
			'spip_biodiv_observations',
			array("id_espece NOT IN ($ids)", "id_espece > 0")
			);
		while ($res = sql_fetch($resultats)) {
			spip_log("BIOCLEAN obs-espece ".$res['id_observation']." ".$res['id_espece'], "biodiv."._LOG_INFO_IMPORTANTE);
		}
	}
	
	sql_updateq(
		'spip_biodiv_observations',
		array('id_espece' => 0),
		array("id_espece NOT IN ($ids)", "id_espece > 0")
		);
	// Par sécurité, on force à (-1) les id_espece des observations inclassables (id_famille <0)
	sql_updateq(
		'spip_biodiv_observations',
		array('id_espece' => -1),
		array("id_famille < 0")
		);

}

?>
