<?php
/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         dédié à la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a été développé initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.         *
 *  Pour plus de détails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

include_spip("inc/obsutil");

/**
 * Vérifie si une observation est éligible pour une campagne donnée
 *
 * @param int $idobs
 *     Identifiant de l'observation
 * @param int $idcamp
 *     Identifiant de la campagne
 * @return string|bool
 *     - true si l'observation est éligible.
 *     - string (message d'erreur) si l'observation n'est pas éligible
 */
function observation_pour_campagne($idobs,$idcamp) {	
	
	// 1. Vérification de la période d'observation
	$campagne = sql_fetsel('*','spip_biodiv_campagnes',"id_campagne = ".intval($idcamp));
	$debut = $campagne['debut'];
	$fin = $campagne['fin'];
	$observation = sql_fetsel('*','spip_biodiv_observations',
				array(
					"id_observation = ".intval($idobs),
					"date_obs <= " . sql_quote($fin),
					"date_obs >= " . sql_quote($debut)
					)
				);
	if(!$observation) {
		return _T('observation:hors_periode');
	}
	
	// 2. Vérification du périmètre
	$peri = sql_fetsel(
				array(
					'liens.id_document AS id_doc',
					'docs.fichier AS fichier'
					),
				array(
					'spip_documents_liens AS liens',
					'spip_documents AS docs'
					),
				array(
					"docs.id_document = liens.id_document",
					"liens.objet = 'campagne'",
					"docs.mode = 'document'",
					"docs.extension = 'lieu'",
					"liens.id_objet = ".intval($idcamp)
					));
	if(!is_array($peri) or !isset($peri['fichier'])) {
		$peri['fichier'] = 'lieu/default.lieu';
		spip_log("Campagne $idcamp : pas de perimetre : perimetre par defaut","biodiv."._LOG_INFO_IMPORTANTE);
	}
	
	$obs = array(array(
		'lat' => $observation['lat'],
		'lng' => $observation['lng'],
		'id' => $idobs
		));
	$result = lieu_polygonal($obs, _NOM_PERMANENTS_ACCESSIBLES . $peri['fichier']);
	if(!in_array($idobs,$result)) {
		return _T('observation:hors_perimetre');
	}
	
	// 2. Vérification de la période d'observation
	$dateObs = $observation['date_obs'];
	$campagne = sql_fetsel('*','spip_biodiv_campagnes',"id_campagne = ".intval($idcamp));
	$debut = $campagne['debut'];
	$fin = $campagne['fin'];
	
	// Fin. Tout est ok
	return true;
}

?>