<?php
/**
 * Définition du modèle Jason pour Biodiv
 *
 * @plugin     Biodiv
 * @copyright  2020
 * @author     Renaud LAURETTE
 * @licence    GNU/GPL
 * @package    SPIP\Biodiv\Jason
 */

/*
Distrib
	SPIP
	MOTS
	FORUM
	SITES
	MEDIAS
	REVISIONS
	
Plugins (select prefixe from spip_plugins)
	BREVES
	PAGES
	AGENDA
	ACCESRESTREINT
	
	SIBMAIL
	SIBACTU
	BIODIV
*/

/**
 * Déclaration de l'API jason pour le plugin Biodiv
 *
 * Cette fonction est appelée par charger_fonction('api','jason-conf/biodiv')
 *
 * @return array
 *		Tableau associatif décrivant l'API
 */
 
 
function jason_conf_biodiv_api_dist() {
	
	// Définition des collections
	
	$collections = array(
		'observations' => array(
			'objet' => 'observation',
			'type' => 'spip',
			'label' => 'observation:titre_biodiv_observations',
			),
		'sources' => array(
			'objet' => 'source',
			'type' => 'spip',
			'label' => 'source:titre_biodiv_sources',
			),
		'taxrefs' => array(
			'objet' => 'taxref',
			'type' => 'spip',
			'label' => 'source:titre_taxref',
			),	
		'campagnes' => array(
			'objet' => 'campagne',
			'type' => 'spip',
			'label' => 'source:titre_biodiv_campagnes',
			),
	
		);
	
	// Définition des objets propres à Biodiv
	
	$objets = array(
		'observation' => array(
			'collection' => 'observations',
			'champs' => array(
					'id_observation'     => array('label' => 'observation:champ_id_observation_label', 'access' => ['read', 'query']),
					'titre'              => array('label' => 'observation:champ_titre_label', 'access' => ['read', 'write', 'query']),
					'creation'           => array('label' => 'observation:champ_creation_label', 'access' => ['read', 'write', 'query']),
					'type_obs'           => array('label' => 'observation:champ_type_obs_label', 'access' => ['read', 'write', 'query']),
					'espece'             => array('label' => 'observation:champ_espece_label', 'access' => ['read', 'write', 'query']),
					'id_espece'          => array('label' => 'observation:champ_id_espece_label', 'access' => ['read', 'write', 'query']),           
					'id_famille'         => array('label' => 'observation:champ_id_famille_label', 'access' => ['read', 'write', 'query']),
					'id_source'          => array('label' => 'observation:champ_id_source_label', 'access' => ['read', 'write', 'query']),
					'ref_source'         => array('label' => 'observation:champ_ref_source_label', 'access' => ['read', 'write', 'query']),
					'id_sujet'           => array('label' => 'observation:champ_id_sujet_label', 'access' => ['read', 'write', 'query']),
					'quantite'           => array('label' => 'observation:champ_quantite_label', 'access' => ['read', 'write', 'query']),
					'denombrement'       => array('label' => 'observation:champ_denombrement_label', 'access' => ['read', 'write', 'query']),
					'date_obs'           => array('label' => 'observation:champ_date_obs_label', 'access' => ['read', 'write', 'query']),
					'pjour'              => array('label' => 'observation:champ_pjour_label', 'access' => ['read', 'write', 'query']),         
					'descriptif'         => array('label' => 'observation:champ_descriptif_label', 'access' => ['read', 'write', 'query']),
					'adresse'            => array('label' => 'observation:champ_adresse_label', 'access' => ['read', 'write', 'query']),
					'commune'            => array('label' => 'observation:champ_commune_label', 'access' => ['read', 'write', 'query']),
					'insee'              => array('label' => 'observation:champ_insee_label', 'access' => ['read', 'write', 'query']),
					'lat'                => array('label' => 'observation:champ_lat_label', 'access' => ['read', 'write', 'query']),
					'lng'                => array('label' => 'observation:champ_lng_label', 'access' => ['read', 'write', 'query']),
					'discret'            => array('label' => 'observation:champ_discret_label', 'access' => ['read', 'write', 'query']),
					'date'               => array('label' => '', 'access' => []),
					'maj'                => array('label' => 'jason:champ_maj_label', 'access' => ['read', 'query']),
					),
			),
		
		'source' => array(
			'collection' => 'sources',                    
			'champs' => array(
					'id_source'          =>  array('label' => 'source:champ_id_source_label', 'access' => ['read', 'query']),
					'titre'              =>  array('label' => 'source:champ_titre_label', 'access' => ['read', 'write', 'query']),
					'creation'           =>  array('label' => 'source:champ_creation_label', 'access' => ['read', 'query']),
					'descriptif'         =>  array('label' => 'source:champ_descriptif_label', 'access' => ['read', 'write', 'query']),
					'acces'              =>  array('label' => 'source:champ_acces_label', 'access' => ['read', 'write', 'query']),
					'identifiant'        =>  array('label' => 'source:champ_identifiant_label', 'access' => ['read', 'write', 'query']),
					'publication'        =>  array('label' => 'source:champ_publication_label', 'access' => ['read', 'write', 'query']),
					'editeur'            =>  array('label' => 'source:champ_editeur_label', 'access' => ['read', 'write', 'query']),
					'support'            =>  array('label' => 'source:champ_support_label', 'access' => ['read', 'write', 'query']),
					'createur'           =>  array('label' => 'source:champ_createur_label', 'access' => ['read', 'write', 'query']),
					'statut_source'      =>  array('label' => 'source:champ_statut_source_label', 'access' => ['read', 'write', 'query']),
					'maj'                =>  array('label' => 'jason:champ_maj_label', 'access' => ['read', 'query']),
					),
			),
		
		'taxref' => array(
			'collection' => 'taxrefs',                     
			'champs' => array(		
					'id_taxref'          => array('label' => 'taxref:champ_id_taxref_label', 'access' => ['read', 'query']), 				// cd_nom
					'cd_ref'             => array('label' => 'taxref:champ_cd_ref_label', 'access' => ['read', 'query']),
					'nom'          	     => array('label' => 'taxref:champ_nom_label', 'access' => ['read', 'query']),
					'id_espece'          => array('label' => 'taxref:champ_id_espece_label', 'access' => ['read', 'write', 'query']),
					'regne'              => array('label' => 'taxref:champ_regne_label', 'access' => ['read', 'query']),
					'group1'             => array('label' => 'taxref:champ_group1_label', 'access' => ['read', 'query']),
					'group2'             => array('label' => 'taxref:champ_group2_label', 'access' => ['read', 'query']),
					'rang'               => array('label' => 'taxref:champ_rang_label', 'access' => ['read', 'query']),
					'sensible'           => array('label' => 'taxref:champ_sensible_label', 'access' => ['read', 'write', 'query']),
					'creation'           => array('label' => 'taxref:champ_creation_label', 'access' => ['read', 'query']),
					'maj'                => array('label' => 'jason:champ_maj_label', 'access' => ['read', 'query']),
					),
			),
		
		'campagne' => array(
			'collection' => 'campagnes',                   
			'champs' => array(			
					'id_campagne'        => array('label' => 'campagne:champ_id_campagne_label', 'access' => ['read', 'query']),
					'id_rubrique'        => array('label' => 'jason:champ_id_rubrique', 'access' => ['read', 'write', 'query']),
					'id_secteur'         => array('label' => 'jason:champ_id_secteur', 'access' => ['read', 'query']),
					'titre'              => array('label' => 'campagne:champ_titre_label', 'access' => ['read', 'write', 'query']),
					'texte'              => array('label' => 'campagne:champ_texte_explication', 'access' => ['read', 'write', 'query']),
					'debut'              => array('label' => 'campagne:champ_debut_explication', 'access' => ['read', 'write', 'query']),
					'fin'                => array('label' => 'campagne:champ_fin_explication', 'access' => ['read', 'write', 'query']),
					'statut'             => array('label' => 'jason:champ_statut_label', 'access' => ['read', 'write', 'query']),
					'maj'                => array('label' => 'jason:champ_maj_label', 'access' => ['read', 'query']),
					),
			),
		
	);	
		
	// Définition des synonymes d'objets
	
	$synonymes = array(
		'espece' 	=> 'article',
		'lieu'		=> 'article',
		'sujet' 	=> 'article',
		'famille' 	=> 'rubrique',
		);
	
	// Aggrégation du modele d'API
	
	$modele = array(
		'collections' 	=> $collections,
		'ressources' 	=> $objets,
		'synonymes'		=> $synonymes,
		);
	
	return $modele;
}

