<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         dédié à la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a été développé initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.         *
 *  Pour plus de détails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/


/*
**	FORMULAIRE_DELIER_ESPECE{�ID_ARTICLE,�URL}
**	S'appelle sur un article, pour y lier une observation suivant un type
**	de lien  'espece'
*/

function formulaires_delier_espece_charger_dist($cle_article=0,$redirect='') {
	if(intval($cle_article)<=0) {
		// protection contre les d�fauts d'appel
		return;
	}

	$valeurs = array(
		'id_article' => $cle_article,
		);
	return $valeurs;
}

function formulaires_delier_espece_verifier_dist($cle_article=0,$redirect='') {
	// Controles
	$erreurs = array();
	if (intval(_request('id_observation'))==(-1)) $erreurs['id_observation'] = _T("observation:msg_lier_selection_obligatoire");
	if (!_request('id_article')) $erreurs['id_article'] = _T("observation:msg_lier_erreur_contexte");
	if(count($erreurs)) {
		$erreurs['message_erreur'] = _T("observation:msg_lier_abandon");
	}
	return $erreurs;
}

include_spip('base/abstract_sql');
include_spip('inc/invalideur');

function formulaires_delier_espece_traiter_dist($cle_article=0,$redirect='') {
	// Nettoyage des paramètres
	$cle_obs= intval(_request('id_observation'));
	$article = intval(_request('id_article'));
	// On recherche la rubrique de l'article
	$row = sql_fetsel(
		array("r.composition AS compo","r.id_rubrique AS idr"),
		array("spip_rubriques AS r", "spip_articles AS a"),
		array("r.id_rubrique = a.id_rubrique", "a.id_article = $article")
		);
	// Si la rubrique de l'article est de type 'espece' alors on lie l'observation
	// à la rubrique en même temps qu'on la délie de l'article. Sinon on ne lie l'observation
	// à rien. En même temps, on dégrade le statut de l'observation à 'prop' (obsolete).
	$idf = 0;
	if($row && ($row['compo']=='espece')) { 
		$idf = $row['idr']; 
		suivre_invalideur("id='rubrique/$idf'");
	}
	$champs_utiles = array(
		"id_espece" => 0,
		"id_famille" => $idf
		// "statut" => "prop"
		);

	if($r = sql_updateq('spip_biodiv_observations',$champs_utiles,"(id_observation=$cle_obs) AND (id_espece=$article)")) {
		$follow_up = _T("observation:msg_delier_ok",array("obs" => $cle_obs));
		// Pipeline
		pipeline('apres_lien_observation',array(
			'id_observation' => $cle_obs,
			'objet' => 'rubrique',
			'nature' => 'famille',
			'id_objet' => $idf
			));		
		pipeline('apres_lien_observation',array(
			'id_observation' => $cle_obs,
			'objet' => 'article',
			'nature' => 'espece',
			'id_objet' => 0
			));	
		// Invalider les caches
		suivre_invalideur("id='article/$article'");
		suivre_invalideur("id='observation/$cle_obs'");
		return array('message_ok'=>$follow_up);
	} else {
		$follow_up = _T("observation:msg_delier_echec", array("err" => $r, "obs" => $cle_obs));
		return array('message_erreur'=>$follow_up);
	}
}


?>
