<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         dédié à la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a été développé initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.         *
 *  Pour plus de détails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

/*
**	FORMULAIRE_DELIER_FAMILLE{ID_RUBRIQUE,URL}
**	S'appelle sur une rubrique, pour y lier une observation
*/

function formulaires_delier_famille_charger_dist($cle_rubrique=0,$redirect='') {
	if(intval($cle_rubrique)<=0) {
		// protection contre les défauts d'appel
		return;
	}

	$valeurs = array(
		'id_rubrique' => $cle_rubrique,
		);
	return $valeurs;
}

function formulaires_delier_famille_verifier_dist($cle_rubrique=0,$redirect='') {
	// Controles
	$erreurs = array();
	if (intval(_request('id_observation'))==(-1)) $erreurs['id_observation'] = _T("observation:msg_lier_selection_obligatoire");
	if (!_request('id_rubrique')) $erreurs['id_rubrique'] = _T("observation:msg_lier_erreur_contexte");
	if(count($erreurs)) {
		$erreurs['message_erreur'] = _T("observation:msg_lier_abandon");
	}
	return $erreurs;
}

function formulaires_delier_famille_traiter_dist($cle_rubrique=0,$redirect='') {
	// Traitement
	include_spip('base/abstract_sql');
	    
	$cle_obs= intval(_request('id_observation'));
	$rubrique = intval(_request('id_rubrique'));
	$action = _request('actionLien');
	$ancLien = intval(sql_getfetsel('id_famille', 'spip_biodiv_observations','id_observation='.$cle_obs));
	// $nvLien = ($action == 'delier') ? 0 : ($ancLien * (-1));
	if($action == 'delier') {
		// En coupant le lien entre la famille et l'observation, on doit rendre 
		// l'observation classable de nouveau. Il faut donc remettre son id_espece à 0
		// A noter : une fois associée à une espèce (id_espece >0) le id_famille est forcé à 0
		// On ne risque donc pas d'effacer l'id_espece ici, car id_famille != 0
		$nvLien = 0;
		$nvEspece = 0;
	} else { 
		// inverser classable/inclassable.
		// Les observations inclassables ont comme id_famille la valeur négative de la famille
		// Leur id_espece ne doit pas rester 0 car sinon elles continuent à apparaitre dans
		// les listes globales d'observations à classer.
		$nvLien = $ancLien * (-1);
		$nvEspece = ($nvLien > 0) ? 0 : (-1);
	}
	$champs_utiles = array(
		"id_famille" => $nvLien,
		"id_espece" => $nvEspece
		);

	if($r = sql_updateq('spip_biodiv_observations',$champs_utiles,"(id_observation=$cle_obs)")) {
		$follow_up = _T("observation:msg_ok_$action",array("obs" => $cle_obs));
		// Pipeline
		pipeline('apres_lien_observation',array(
			'id_observation' => $cle_obs,
			'objet' => 'rubrique',
			'nature' => 'famille',
			'id_objet' => $nvLien
			));	
		// Invalider les caches
		include_spip('inc/invalideur');
		suivre_invalideur("id='rubrique/$rubrique'");
		return array('message_ok'=>$follow_up);
	} else {
		$follow_up = _T("observation:msg_echec_$action", array("err" => $r, "obs" => $cle_obs));
		return array('message_erreur'=>$follow_up);
	}
}


?>
