<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         ddi  la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a t dvelopp initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu sous licence GNU/GPL.         *
 *  Pour plus de dtails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

include_spip("inc/autoriser");

function formulaires_depouiller_observation_charger_dist($id_observation=0, $id_document=0, $redirect='') {
	// verifier les droits
	if(!autoriser('modifier', 'observation', $id_observation)) {
		return false;
	}
		
	// verifier l'existance de la relation
	$nb_illus = sql_countsel('spip_documents_liens', 
			"(id_objet=$id_observation) AND (objet='observation') AND (id_document=$id_document)");
			
	if(intval($nb_illus) != 1) {
		return false;
	}

	// Initialisation du formulaire
	$valeurs = array(
		'id_observation' => $id_observation, 	// identifiant de l'observation
		'id_document' => $id_document, 		// identifiant du document
	);	
	return $valeurs;
}


function formulaires_depouiller_observation_verifier_dist($id_observation=0, $id_document=0, $redirect='') {
	// pas de vrification spcifique : contrles au chargement et pas de saisie
	$erreurs = array();
	return $erreurs;
}

function formulaires_depouiller_observation_traiter_dist($id_observation=0,$id_document=0,$redirect='') {
	

	if(!sql_countsel("spip_documents","id_document=$id_document")) {
		// pas de document ?!
		$resultat = array('message_erreur' => _T('observation:msg_document_inconnu'));
		return $resultat;
	} 
	
	// document trouv - on supprime le lien
	// et aussi le document s'il ne reste pas d'autre lien
	include_spip('action/dissocier_document');
	$supprimer_orphelin = true;
	if (supprimer_lien_document($id_document,'observation',$id_observation,$supprimer_orphelin)) {
		$resultat = array(
			'message_ok' => _T('observation:msg_document_supprime_ok'),
			'redirect' => $redirect,
			);
	} else {
		$resultat = array(
			'message_erreur' => _T('observation:msg_document_supprime_echec'),
			);
	}
	return $resultat;

}


?>
