<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         ddi  la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a t dvelopp initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu sous licence GNU/GPL.         *
 *  Pour plus de dtails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

include_spip("inc/autoriser");

function formulaires_desaffecter_observation_charger_dist($id_observation=0, $id_objet=0, $objet='', $redirect='') {
	// verifier les droits
	if(!autoriser('modifier', 'observation', $id_observation)) {
		return false;
	}

	// Initialisation du formulaire
	$dvaleurs = array(
		'id_observation' => $id_observation, 	// identifiant de l'observation
		'id_objet' => $id_objet, 				// identifiant de l'objet li
		'objet' => $objet						// nature de l'objet
	);	
	return $dvaleurs;
}


function formulaires_desaffecter_observation_verifier_dist($id_observation=0, $id_objet=0, $objet='', $redirect='') {
	// Vrification de l'existance de la relation
	if(!sql_countsel('spip_biodiv_observations_liens', array(
					"id_observation=".intval($id_observation),
					"id_objet=".intval($id_objet),
					"objet=".sql_quote($objet)
					))) {
		return array('message_erreur' => _T('observation:affectation_inconnue'));
	}

	return array();
}

include_spip('inc/invalideur');

function formulaires_desaffecter_observation_traiter_dist($id_observation=0, $id_objet=0, $objet='', $redirect='') {
	
	sql_delete('spip_biodiv_observations_liens', array(
		"id_objet=".intval($id_objet),
		"objet=".sql_quote($objet),
		"id_observation=".intval($id_observation)
		));
	suivre_invalideur("id='observation/$id_observation'");
	
	$resultat = array(
			'message_ok' => _T('observation:affectation_supprimee'),
			'redirect' => $redirect,
			);

	return $resultat;
}


?>
