<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         ddi  la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a t dvelopp initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu sous licence GNU/GPL.         *
 *  Pour plus de dtails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

include_spip("inc/autoriser");
include_spip("inc/obsutil");


function formulaires_documenter_observation_charger_dist($id_observation=0, $id_document=0, $redirect='') {
	// verifier les droits
	if(!autoriser('modifier', 'observation', $id_observation)) {
		return false;
	}
		
	// dfinir le numro de la prochaine illustration par comptage des existantes
	$nb_illus = sql_countsel('spip_documents_liens', "(id_objet=$id_observation) AND (objet='observation')");
		
	$formats_autorises = array_keys(documenter_observation_formats());
	sort($formats_autorises);

	// Initialisation du formulaire
	// $id_document ignor pour l'instant
	$valeurs = array(
		'id_observation' => $id_observation, 	// identifiant de l'observation
		'rg_document' => $nb_illus, 		// numro de la prochaine illustration
		'formats_autorises' => $formats_autorises
	);	
	return $valeurs;
}



function formulaires_documenter_observation_verifier_dist($id_observation=0, $id_document=0, $redirect='') {
	include_spip('inc/acces');
	include_spip('inc/texte');
	include_spip('inc/forum');
	include_spip('inc/session');
	include_spip('base/abstract_sql');

	$erreurs = array();
		
	// cohrence aller-retour
	$idobs = _request('id_observation');
	if(intval($idobs)!=intval($id_observation)) {
		$erreurs['message_erreur'] = _T('observation:msg_observation_inconnue');
		return $erreurs;
	}
	
	// prvenir les chargements en parallle
	$nb_illus = sql_countsel('spip_documents_liens',"(id_objet=$idobs) AND (objet='observation')");
	if(intval($nb_illus) != intval(_request('rg_document'))) {
		$erreurs['message_erreur'] = _T('observation:msg_acces_concurrent');
		return $erreurs;
	}
	
	// vrifier le fichier transmis
	if (isset($_FILES['fichobs']) AND $_FILES['fichobs']['tmp_name']) {
		$doc=&$_FILES['fichobs'];

		// Gestion de l'extension et gnration du nom de fichier cible
		$extension='noext';
		if(preg_match(',\.([a-z0-9]+)(\?.*)?$,i', $doc['name'], $match)) {
			$extension = $match[1];
		}
		$extok = documenter_observation_formats();
		$acceptes = array_keys($extok);
		if (!in_array($extension, $acceptes)) {
			$lname=$doc['name'];
			$erreurs['message_erreur'] = _T('observation:msg_extension_refusee');
		} else {
			$radical = radical_cible_observation($idobs,$nb_illus);
			$goodext = $extok[$extension];
			$fcible = $radical . "." . $goodext;
			$doc['name'] = $fcible;
			// Controle de la taille
			if($doc['size'] > taille_max_format($goodext)) {
				$erreurs['message_erreur'] = _T('observation:msg_fichier_trop_gros');
			}	
		}
	} else {
		spip_log("[Biodiv] -- Verification - pb upload", "Illustrer");
		$erreurs['message_erreur'] = _T('observation:msg_telechargement_echec');
	}
	return $erreurs;
}

function formulaires_documenter_observation_traiter_dist($id_observation=0,$id_document=0,$redirect='') {
	spip_log("[Biodiv] -- Traitement - DEBUT", "Documenter");
	
	if (isset($_FILES['fichobs']) AND $_FILES['fichobs']['tmp_name']) {
		$doc=&$_FILES['fichobs'];
		include_spip('action/ajouter_documents');
		$ajouter_un_document = charger_fonction('ajouter_un_document', 'action');
		
		// On rcupre les donnes sur l'aobservation et l'auteur des images
		$obsdata = sql_fetsel(array('titre'),'spip_biodiv_observations',"id_observation=".intval($id_observation));
		$autdata = sql_fetsel(array('nom'),'spip_auteurs',"id_auteur=".intval(session_get('id_auteur')));
		

		$docid = $ajouter_un_document('new',$doc,'observation',$id_observation,'document');
		spip_log("[Biodiv] -- Creation du document $docid", "Illustration");
		spip_unlink($doc['tmp_name']);
		// Aprs cration du doc, on donne comme titre celui de l'observation
		// et comme crdits le nom de l'utilisateur connect
		sql_updateq('spip_documents',
				array(
					'credits' => $autdata['nom'],
					'titre' => $obsdata['titre']
					),
				"id_document=".intval($docid)
				);			
		spip_log("[Biodiv] -- Maj document $docid : credits='".$autdata['nom']."' titre='".$obsdata['titre']."'", "Illustration");
		$resultat = array(        
			'message_ok' => _T('observation:msg_telechargement_ok'),
			'redirect' => $redirect,
			);
	} else {
		$resultat = array(
			'message_erreur' => _T('biodiv:echec_telechargement'),
			);
	}
	return $resultat;
}


?>
