<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         ddi  la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a t dvelopp initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu sous licence GNU/GPL.         *
 *  Pour plus de dtails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

include_spip("inc/autoriser");
include_spip('action/editer_objet');


function formulaires_enregistrer_observations_charger_dist($redirect=null) {
	// Initialisation du formulaire
	$valeurs = array();
	// verifier les droits
	if(!autoriser('ordonner')) {
		$valeurs['editable'] = false;
		return $valeurs;
	}	
	return $valeurs;
}

function preparer_date($datein) {
	$formats = array("d/m/Y","d.m.Y","Y-m-d","d/m/y");
	foreach($formats as $format) {
		$adate = date_parse_from_format($format,$datein);
		if(!$adate['error_count']) {
			$bdate = date_create_from_format($format,$datein);
			return date_format($bdate,'Y-m-d');
		}
	}
	return "error";
}

$geoOrdres = array();

function controler_feature($feature) {
	global $geoOrdres;
	$erreur = true;
	$o = array();
	$v = var_export($feature,true);
	spip_log("[Enregistrer Observations] -- controler_feature: ".$v, "Biodiv");
	if( 	isset($feature['type'])
		and ($feature['type'] == 'Feature')
		and	is_array($feature['geometry'])
		and isset($feature['geometry']['type'])
		and	($feature['geometry']['type'] == 'Point')
		and	is_array($feature['geometry']['coordinates'])
		and	is_array($feature['properties'])
		) {
			$erreur = false;
			$data = $feature['properties'];	
			spip_log("[Enregistrer Observations] -- controler_feature en dtail", "Biodiv");
			// champs obligatoires
			foreach(array('titre','espece','pjour','discret') as $champ) {
				if(isset($data[$champ])) {
					$o[$champ] = $data[$champ];
				} else {
					$erreur = true;
					spip_log("[Enregistrer Observations] -- Erreur champ ".$champ, "Biodiv");
				}
			}
			if(isset($data['date_obs'])) {
				$o['date_obs'] = preparer_date($data['date_obs']);
			} else {
				$erreur = true;
				spip_log("[Enregistrer Observations] -- Erreur champ date_obs", "Biodiv");
			}			
			$o['lng'] = $feature['geometry']['coordinates'][0];
			$o['lat'] = $feature['geometry']['coordinates'][1];
			$o['type_obs']='espece';
			
			// Valeurs par dfaut (applicatif)
			$o['titre'] = isset($data['titre'])?$data['titre']:$o['espece'];
			$quantite = intval((string)$data['quantite']);
			$o['quantite'] = ($quantite ==0 ) ? 1 : $quantite;	
			
			// Valeurs par dfaut et champs facultatifs (database)
			foreach (array('denombrement','adresse','descriptif','commune','insee') as $champ) {
				if(isset($data[$champ])) $o[$champ] = $data[$champ];
			}
		}		
	return $erreur?false:$o;	
}

// vrification du format des donnes et prparation
function formulaires_enregistrer_observations_verifier_dist($redirect=null) 
{
	global $geoOrdres;
	$erreurs = array();
	$collection = json_decode(_request('geodata'),true);
	spip_log("[Enregistrer Observations] -- verification", "Biodiv");
	//$v = var_export($collection, true);
	//spip_log("[Enregistrer Observations] -- detail: ".$v, "Biodiv");
	if($collection['type'] == "FeatureCollection") {
		//spip_log("[Enregistrer Observations] -- verification collection", "Biodiv");
		$features = $collection['features'];
		foreach($features as $feature) {
			$ordre = controler_feature($feature);
			if (!$ordre) {
				$erreurs['message_erreur'] = _T('biodiv:feature_incorrect');
				return $erreurs;
			} else {
				$geoOrdres[] = $ordre;
			}
		}
	} else {
		// Les donnes ne sont pas une collection de Feature GeoJSON
		// Est-ce un feature unique ?
		// spip_log("[Enregistrer Observations] -- verification feature unique", "Biodiv");
		$ordre = controler_feature($collection);
		if (!$ordre) {
				$erreurs['message_erreur'] = _T('biodiv:feature_incorrect');
				return $erreurs;
		} else {
				$geoOrdres[] = $ordre;
		}
	}
	return $erreurs;
}



// Fonction de traitement
function formulaires_enregistrer_observations_traiter_dist($redirect=null) {
	global $geoOrdres;
	spip_log("[Enregistrer Observations] -- Traitement", "Biodiv");
	$resultat = array();
	$resultat['titre'] = "Enregistrement des observations du parcours";
	$obsok = array();
	$avancement="";	// Description des instructions excutes
	foreach($geoOrdres as $ordre) {
		$id_observation = objet_inserer('observation'); //insert_observation();	
    	  if($id_observation>0) {
    	  	  // Observation cre. On ajoute le contenu
    	  	  spip_log("[Enregistrer Observations] -- observation cre", "Biodiv");
    	  	  // $ordre['statut']='prop'; 
    	  	  $err = objet_modifier('observation',$id_observation,$ordre);
    	  	  //revisions_observations($id_observation, $ordre);
    	  	  // $avancement .= 'Obs '.$id_observation.' '.$ordre['titre'].' ('. $ordre['quantite'] . ' ' . $ordre['espece'] .')<br/>';
    	  	  // $resultat['message_ok'] = $avancement;
    	  	  $obsok[] = $id_observation;
    	  	  // $resultat['obsok'] = $obsok;
    	  } else {
    	  	  spip_log("[Enregistrer Observations] -- chec cration", "Biodiv");
    	  	  //$avancement .= 'ECHEC: '.$ordre['titre'].' ('. $ordre['quantite'] . ' ' . $ordre['espece'] .')';
    	  	  $resultat['message_erreur'] = 'ECHEC: '.$ordre['titre'].' ('. $ordre['quantite'] . ' ' . $ordre['espece'] .')';
    	  	  $resultat['obsok'] = implode(',',$obsok);
    	  	  if($redirect) {  
    	  	  	  $resultat['redirect'] = generer_url_public($redirect,$resultat);
    	  	  }
    	  	  return $resultat;
    	  }
    }
	$resultat['message_ok'] ='Observations mises en base.';
	$resultat['obsok'] = implode(',',$obsok);
	if($redirect) {
    	$resultat['redirect'] = generer_url_public($redirect,$resultat);
    	}
    return $resultat;
}



?>
