<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         ddi  la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a t dvelopp initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu sous licence GNU/GPL.         *
 *  Pour plus de dtails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

include_spip("inc/autoriser");
include_spip("inc/ordres_biodiv");


function formulaires_enregistrer_parcours_charger_dist() {

	// Initialisation du formulaire
	$valeurs = array();
	// verifier les droits
	if(!autoriser('ordonner')) {
		$valeurs['editable'] = false;
		return $valeurs;
	}
	
	return $valeurs;
}



function formulaires_enregistrer_parcours_verifier_dist() 
{
	$erreurs = array();
			
	// vrifier le fichier transmis
	if (isset($_FILES['ordres']) AND $_FILES['ordres']['tmp_name']) {
		$doc=&$_FILES['ordres'];
		// Chargement DOM du XML
		$ordresXml = new DOMDocument();
		if(!$ordresXml->load(realpath($doc['tmp_name']))) {
			$erreurs['message_erreur'] = _T('biodiv:echec_parse_xml');
		} else {
			// Reception et parsing xml ok - on transforme
			if($f=find_in_path("xsl/gpx4spip.xsl")) {
				// transfo XSL trouve - on la charge comme XML
				$xslDoc = new DOMDocument();
				if($xslDoc->load(realpath($f))) {
					// Transformation
					$proc = new XSLTProcessor();
					$proc->importStylesheet($xslDoc);
					$out = $proc->transformToDoc($ordresXml);
					// sauvegarde du resultat dans un fichier temporaire
					$outfile = realpath(tempnam(_NOM_TEMPORAIRES_INACCESSIBLES,"order"));
					$out->save($outfile);
					// Remplacement du fichier charg par le fichier calcul
					unlink($doc['tmp_name']);
					$doc['tmp_name'] = $outfile;
				} else {
					$erreurs['message_erreur'] = _T('biodiv:echec_load_xsl');
				}
			} else {
				$erreurs['message_erreur'] = _T('biodiv:no_xsl');
			}
		}
		
	} else {
		spip_log("[Biodiv] -- Verification - pb upload", "Ordonner Biodiv");
		$erreurs['message_erreur'] = _T('biodiv:echec_telechargement');
	}
	return $erreurs;
}

// Fonction de traitement
// A ce stade, le fichier $_FILES['ordres'] n'est plus le fichier tlcharg, mais le
// rsultat de la transformation XSL : c'est devenu un fichier d'ordres prcis  traiter.
// Ces ordres vont tre traits un par un via SimpleXML

function formulaires_enregistrer_parcours_traiter_dist() {
	spip_log("[Biodiv] -- Traitement - DEBUT", "Enregistrer parcours");
	$resultat = array();
	$doc=&$_FILES['ordres'];
	$ordresXml = simplexml_load_file($doc['tmp_name']);
	$numOrdre=0;	// Rang de l'ordre dans le fichier
	$avancement="";	// Description des instructions excutes
	
	foreach($ordresXml->creer as $creer) {
		// Traitement des ordres destins  lier deux objets
		// Prparation de la description de l'ordre
		$numOrdre++; $avx='';
		foreach($creer->attributes() as $key => $value) { $avx .= ' '.$key.'='.$value; }
		$avancement .= $numOrdre . ": Creer $avx ";
		// On parse l'ordre pour crer une structure excutable, et on dclenche l'excution
		$ordre = ordreCreer($creer);
		// On examine le statut retourn par l'excution
		if($ordre['pret']) {
			// Succs de l'ordre crer - on enregistre le statut
			$self = $ordre['id'];
			$avancement .= " : ok id=$self<br/>";
			$resultat['message_ok'] = $avancement;
		} else {
			// Echec : on enregistre le statut et on interrompt
			$avancement .= ' : '. _T('biodiv:echec') .' : ' . $ordre['erreur'] . '<br/>' . _T('biodiv:traitement_interrompu');
			$resultat['message_erreur'] = $avancement;
			return $resultat;
		}
	}
	
	// D'autres ordres ventuels devraient tre insrs ici
	
	// Tout est fini
	// On dtruit le fichier temporaire des ordres et on retourne le rsultat
	$avancement.='<br/><b>' . _T('biodiv:succes_ordonner',array('qty'=>$numOrdre)) . '</b><br/>';
	$resultat['message_ok'] = $avancement;
	unlink($doc['tmp_name']);
	return $resultat;
}



?>
