<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         dédié à la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a été développé initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.         *
 *  Pour plus de détails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

include_spip("inc/autoriser");
include_spip("inc/obsutil");


function formulaires_illustrer_observation_charger_dist($id_observation=0, $id_document=0, $redirect='') {
	// verifier les droits
	if(!autoriser('modifier', 'observation', $id_observation)) {
		return false;
	}
		
	// définir le numéro de la prochaine illustration par comptage des existantes
	$nb_illus = sql_countsel('spip_documents_liens', "(id_objet=$id_observation) AND (objet='observation')");

	// Initialisation du formulaire
	// $id_document ignoré pour l'instant
	$valeurs = array(
		'id_observation' => $id_observation, 	// identifiant de l'observation
		'rg_document' => $nb_illus		// numéro de la prochaine illustration
	);	
	return $valeurs;
}



function formulaires_illustrer_observation_verifier_dist($id_observation=0, $id_document=0, $redirect='') {
	include_spip('inc/acces');
	include_spip('inc/texte');
	include_spip('inc/forum');
	include_spip('inc/session');
	include_spip('base/abstract_sql');

	$erreurs = array();
		
	// cohérence aller-retour
	$idobs = _request('id_observation');
	if(intval($idobs)!=intval($id_observation)) {
		$erreurs['message_erreur'] = _T('observation:msg_observation_inconnue');
		return $erreurs;
	}
	
	// prévenir les chargements en parallèle
	$nb_illus = sql_countsel('spip_documents_liens',"(id_objet=$idobs) AND (objet='observation')");
	if(intval($nb_illus) != intval(_request('rg_document'))) {
		$erreurs['message_erreur'] = _T('observation:msg_acces_concurrent');
		return $erreurs;
	}
	
	// vérifier les fichier transmis
	$upload_dir = _DIR_TMP . "upload/";
	$fieldName="fichobs";
	$pbs=""; $nofile = true;
	foreach($_POST as $key => $value) {
		if(strncmp($key,$fieldName,strlen($fieldName))==0) {
			$img = $_POST[$key];
			$img = str_replace('data:image/jpeg;base64,', '', $img);
			$img = str_replace(' ', '+', $img);
			$data = base64_decode($img);
			$file = $upload_dir . "o$id_observation". $key . ".jpg";
			$success = file_put_contents($file, $data);
			if($success) {
				$nofile= false;
			} else {
				$pbs .= "$key ";
			}
		}
	}
	
	if(strlen($pbs) !=0) 
		$erreurs['message_erreur'] = _T('observation:msg_telechargement_echec'). " $pbs";
	
	if($nofile)
		$erreurs['message_erreur'] = _T('observation:msg_fichier_absent');
	
	return $erreurs;
}

function formulaires_illustrer_observation_traiter_dist($id_observation=0,$id_document=0,$redirect='') {
	spip_log("[Biodiv] -- Traitement - DEBUT", "Illustration");
	
	include_spip('action/ajouter_documents');
	$ajouter_un_document = charger_fonction('ajouter_un_document', 'action');
	
	$upload_dir = _DIR_TMP . "upload/";
	$fieldName="fichobs";
	$sigName="sigobs";
	$nb_illus = sql_countsel('spip_documents_liens',"(id_objet=$id_observation) AND (objet='observation')");
	
	// On récupère les données sur l'aobservation et l'auteur des images
	$obsdata = sql_fetsel(array('titre'),'spip_biodiv_observations',"id_observation=".intval($id_observation));
	$autdata = sql_fetsel(array('nom'),'spip_auteurs',"id_auteur=".intval(session_get('id_auteur')));
	
	for($idk=0; array_key_exists($fieldName.$idk,$_POST); $idk++) {
		$key= $fieldName.$idk;
		$file = $upload_dir . "o$id_observation". $key . ".jpg";
		$fcible = radical_cible_observation($id_observation,$nb_illus++) . ".jpg";
		$download = array(
			'name' => $fcible,
			'tmp_name' => $file,
			'type' => 'image/jpeg',
			'size' => filesize($file),
			'error' => UPLOAD_ERR_OK
			);
		$docid = $ajouter_un_document('new',$download,'observation',$id_observation,'document');
		spip_log("[Biodiv] -- Creation du document $docid", "Illustration");
		spip_unlink($download['tmp_name']);
		// Après création du doc, on donne comme titre celui de l'observation
		// et comme crédits le nom de l'utilisateur connecté si aucun nom n'a été transmis
		$ks = $sigName.$idk;
		$nomAuteur = array_key_exists($ks,$_POST) ? $_POST[$ks] : $autdata['nom'];
		sql_updateq('spip_documents',
				array(
					'credits' => $nomAuteur,
					'titre' => $obsdata['titre']
					),
				"id_document=".intval($docid)
				);	
		spip_log("[Biodiv] -- Maj document $docid : credits='".$nomAuteur."' titre='".$obsdata['titre']."'", "Illustration");
	}
	
	$resultat = array(
		'message_ok' => _T('observation:msg_telechargement_ok'),
		'redirect' => $redirect,
		);				
	return $resultat;
}


?>
