<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         d�di� � la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a �t� d�velopp� initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu� sous licence GNU/GPL.         *
 *  Pour plus de d�tails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

/*
 * Cr�ation d'observation � partir d'une photo instantann�e (date du jour)
 */

include_spip("inc/autoriser");
include_spip("inc/obsutil");
include_spip('inc/actions');
include_spip('inc/editer');


function formulaires_saisir_observation_charger_dist($redirect='') {
	// verifier les droits

	// initialisations
	$valeurs = array();
	return $valeurs;
}


function formulaires_saisir_observation_verifier_dist($redirect='') {	

	$erreurs = array();
	$uniqueid = rand(1000,9999);
	$xchamps = array(
		"titre" => "Nouvelle observation",
		"type_obs" => "espece",
		"espece" => "Inconnue",
		"quantite" => 1,
		"date_obs" => date("Y-m-d"),
		"discret" => "non",
		"pjour" => periode_du_jour(intval(date("H")))
		);
		
	// v�rifier les champs transmis
	$upload_dir = _DIR_TMP . "upload/";
	if(!file_exists($upload_dir)) {
		mkdir($upload_dir);
	}
	$fieldName="fichobs";
	$pbs=""; $nofile = true;
	foreach($_POST as $key => $value) {
		if(strncmp($key,$fieldName,strlen($fieldName))==0) {
			// on est sur un fichier
			$img = $_POST[$key];
			$img = str_replace('data:image/jpeg;base64,', '', $img);
			$img = str_replace(' ', '+', $img);
			$data = base64_decode($img);
			$file = $upload_dir . "o$uniqueid". $key . ".jpg";
			$success = file_put_contents($file, $data);
			if($success) {
				$nofile= false;
			} else {
				$pbs .= "$key ";
			}
		} else {
			// le champ n'est pas un fichier
			spip_log("[Biodiv] -- champ $key", "SaisieRapide");
			switch($key) {
			case "titre":
				$xchamps[$key] = $value;
				if($_POST['type_obs']!='espece') {
					$xchamps["espece"] = "(aucune)";
				} else {
					$xchamps["espece"] = $value;
				}
				break;
			case "quantite":
			case "insee":
				$xchamps[$key] = intval($value);
				break;			
			case "lat":
			case "lng":
			case "adresse":		
			case "commune":
			case "type_obs":
				$xchamps[$key] = $value;
				break;
			default:
				break;
			}
		}
	}
	// Valeurs suppl�mentaires
	$qFields = array();
	$_POST["uid"] = $uniqueid;
	foreach (array(
			// Pour chacun de ces champs,
			'titre', 'espece', 'quantite', 'date_obs', 'id_famille',
			'pjour', 'descriptif', 'adresse', 'commune', 'insee',
			'type_obs', // 'statut',
			'id_source', 'ref_source', 'denombrement',
			'lat','lng','discret'
		) as $c) {
			if(array_key_exists($c,$xchamps)) {
				$qFields[$c] = $xchamps[$c];
			}
		}
	session_set("o$uniqueid",$qFields);
	
	if(strlen($pbs) !=0) 
		$erreurs['message_erreur'] = _T('biodiv:echec_telechargement'). " $pbs";
	
	if($nofile)
		$erreurs['message_erreur'] = _T('biodiv:aucun_fichier');
	
	/* DEBUG START */
	$id_auteur = ((is_null(_request('id_auteur')) and isset($GLOBALS['visiteur_session']['id_auteur'])) ?
				$GLOBALS['visiteur_session']['id_auteur']
				: _request('id_auteur'));
	if(!$id_auteur) {
		$erreurs['message_erreur'] = "PB avec id_auteur";
	}
	/* DEBUG END */
	return $erreurs;
}

include_spip('action/editer_objet');
include_spip('action/ajouter_documents');
	
function formulaires_saisir_observation_traiter_dist($redirect='') {
		
	spip_log("[Biodiv] -- Traitement - DEBUT", "SaisieRapide");
	$uniqueid = _request("uid");
	$qFields = session_get("o$uniqueid");
	
	// Cr�ation de l'observation
	$id_observation = objet_inserer('observation');
	$err = objet_modifier('observation',$id_observation,$qFields);
	
	/*
	$retours = formulaires_editer_objet_traiter('observation', 'new', $redirect);
	$id_observation = $retours['id_observation'];
	*/
	$ajouter_un_document = charger_fonction('ajouter_un_document', 'action');
	
	$upload_dir = _DIR_TMP . "upload/";
	$fieldName="fichobs";
	$nb_illus = sql_countsel('spip_documents_liens',"(id_objet=$id_observation) AND (objet='observation')");
	
	// On r�cup�re les donn�es sur l'observation et l'auteur des images
	$obsdata = sql_fetsel(array('titre'),'spip_biodiv_observations',"id_observation=".intval($id_observation));
	$autdata = sql_fetsel(array('nom'),'spip_auteurs',"id_auteur=".intval(session_get('id_auteur')));
	
	
	foreach($_POST as $key => $value) {
		if(strncmp($key,$fieldName,strlen($fieldName))==0) {
			// $pidx = substr($key,strlen($fieldName));
			$file = $upload_dir . "o$uniqueid". $key . ".jpg";
			// $pname = $_POST['nameobs'.$pidx];
			$fcible = radical_cible_observation($id_observation,$nb_illus++) . ".jpg";
			$download = array(
				'name' => $fcible,
				'tmp_name' => $file,
				'type' => 'image/jpeg',
				'size' => filesize($file),
				'error' => UPLOAD_ERR_OK
				);
			$docid = $ajouter_un_document('new',$download,'observation',$id_observation,'document');
			spip_log("[Biodiv] -- Creation du document $docid", "SaisieRapide");
			spip_unlink($download['tmp_name']);
			// Apr�s cr�ation du doc, on donne comme titre celui de l'observation
			// et comme cr�dits le nom de l'utilisateur connect�
			sql_updateq('spip_documents',
					array(
						'credits' => $autdata['nom'],
						'titre' => $obsdata['titre']
						),
					"id_document=".intval($docid)
					);	
			spip_log("[Biodiv] -- Maj document $docid : credits='".$autdata['nom']."' titre='".$obsdata['titre']."'", "SaisieRapide");
		}
	}
	$resultat = array(
		'id_observation' => $id_observation,
		'message_ok' => _T('biodiv:telechargement_reussi'),
		'redirect' => $redirect,
		);				
	return $resultat;
}

?>
