<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         ddi  la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a t dvelopp initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu sous licence GNU/GPL.         *
 *  Pour plus de dtails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

include_spip("inc/autoriser");

function formulaires_supprimer_observation_charger_dist($id_observation=0, $redirect='') {
	// verifier les droits
	if(!autoriser('supprimer', 'observation', $id_observation)) {
		return false;
	}

	// Initialisation du formulaire
	$valeurs = array(
		'id_observation' => $id_observation, 	// identifiant de l'observation
	);	
	return $valeurs;
}


function formulaires_supprimer_observation_verifier_dist($id_observation=0, $redirect='') {
	$erreurs = array();
	// verifier les droits
	if(!autoriser('supprimer', 'observation', $id_observation)) {
		$erreurs =  array(
			'message_erreur' => _T('observation:msg_suppression_observation_refus'),
			);
	}
	return $erreurs;
}

include_spip('action/editer_liens');

function formulaires_supprimer_observation_traiter_dist($id_observation=0, $redirect='') 
{
	// suppression des liens  l'observation et du document s'il n'a pas d'autre lien
	include_spip('action/documenter');
	$erreurs = 0;
    if ($resultats = sql_select('*', 'spip_documents_liens', "id_objet=$id_observation AND objet='observation'")) {
    	// boucler sur les resultats
    	while ($res = sql_fetch($resultats)) {
    		$id_document = $res['id_document'];
    		// $erreurs = supprimer_lien_document($id_document,'observation',$id_observation) ? $erreurs +1 : $erreurs ;
    		$erreurs= objet_dissocier(array('document' => $id_document), '*', array('role' => '*')) ? $erreurs : $erreurs +1;
    	}
    }
    // On s'arrte en cas de problme
    if($erreurs) {
    	return array(
			'message_erreur' => _T('observation:msg_suppression_doclie_echec'),
			);
    }
    // suppression de l'observation
    include_spip('inc/invalideur');
    if(sql_delete('spip_biodiv_observations',"id_observation=$id_observation")) {
    	suivre_invalideur("id='observation/$id_observation'");
    	return array(
			'message_ok' => _T('observation:msg_suppression_observation_ok'),
			'redirect' => $redirect,
			);
	} else {
		return array(
			'message_erreur' => _T('observation:msg_suppression_observation_echec'),
			);
	}

}


?>
