<?xml version="1.0" encoding="iso-8859-1"?>

<!--

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         ddi  la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a t dvelopp initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu sous licence GNU/GPL.         *
 *  Pour plus de dtails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

  Document   : freemind4spip.xsl
  Version    : 2
  Created on : 12 Decembre 2014
  Updated on : Aout 2020
  Author     : renaud.laurette
  Comment    : 
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		version="1.0">

<!-- Sortie avec caractres US pour forcer entites XML -->
  <xsl:output method="xml" version="1.0" encoding="us-ascii"/>
  
  <!-- paramtrage du fichier mm original -->
  <xsl:variable name="rubrique" select="'#00bb3a'"/>
  <xsl:variable name="article" select="'#0000ff'"/>
  <xsl:variable name="campagne" select="'#993300'"/>
  <xsl:variable name="observation" select="'#ff0000'"/>
  <xsl:variable name="lier" select="'#OBSERVATIONS'"/>
  <xsl:variable name="creerEspece" select="'#ESPECES'"/>
  <xsl:variable name="creerSujet" select="'#SUJETS'"/>
  <xsl:variable name="creerPanneau" select="'#PANNEAUX'"/>

  <xsl:template match="/">
    <xsl:element name="ordresBiodiv">
      <xsl:apply-templates select="//node[@TEXT=$lier and ../@COLOR=$rubrique]" mode="lienRubrique"/>
      <xsl:apply-templates select="//node[@TEXT=$lier and ../@COLOR=$article]" mode="lienArticle"/>
      <xsl:apply-templates select="//node[@TEXT=$lier and ../@COLOR=$campagne]" mode="lienCampagne"/>
      <xsl:apply-templates select="//node[@TEXT=$creerEspece]" mode="creerArticle">
      	<xsl:with-param name="composition" select="'espece'"/>
      </xsl:apply-templates>
      <xsl:apply-templates select="//node[@TEXT=$creerSujet]" mode="creerArticle">
      	<xsl:with-param name="composition" select="'sujet'"/>
      </xsl:apply-templates>
      <xsl:apply-templates select="//node[@TEXT=$creerPanneau]" mode="creerArticle">
      	<xsl:with-param name="composition" select="'expo'"/>
      </xsl:apply-templates>
    </xsl:element>
  </xsl:template>

   <xsl:template match="node" mode="lienRubrique">
     <xsl:variable name="lid"><xsl:value-of select="../attribute[@NAME='id_rubrique']/@VALUE"/></xsl:variable>
     <xsl:for-each select="node">
         <xsl:choose>
           <xsl:when test="@COLOR=$observation">      
                <xsl:element name="lier">
                 <xsl:attribute name="xObjet">observation</xsl:attribute>
                 <xsl:attribute name="xRelation">observation.famille</xsl:attribute>
                 <xsl:attribute name="id_famille"><xsl:value-of select="$lid"/></xsl:attribute>
                 <xsl:attribute name="id_observation"><xsl:value-of select="attribute[@NAME='id_observation']/@VALUE"/></xsl:attribute>
               </xsl:element>
           </xsl:when>
         </xsl:choose>
       </xsl:for-each>
   </xsl:template>
   
   <xsl:template match="node" mode="lienArticle">
     <xsl:variable name="lid"><xsl:value-of select="../attribute[@NAME='id_article']/@VALUE"/></xsl:variable>
     <xsl:variable name="composition"><xsl:value-of select="../attribute[@NAME='_composition']/@VALUE"/></xsl:variable>
     <xsl:for-each select="node">
       <xsl:if test="@COLOR=$observation">
         <xsl:choose>
           <xsl:when test="$composition='espece'">       
                <xsl:element name="lier">
                 <xsl:attribute name="xObjet">observation</xsl:attribute>
                 <xsl:attribute name="xRelation">observation.espece</xsl:attribute>
                 <xsl:attribute name="id_espece"><xsl:value-of select="$lid"/></xsl:attribute>
                 <xsl:attribute name="id_observation"><xsl:value-of select="attribute[@NAME='id_observation']/@VALUE"/></xsl:attribute>
               </xsl:element>
           </xsl:when>
           <xsl:when test="$composition='sujet'">       
                <xsl:element name="lier">
                 <xsl:attribute name="xObjet">observation</xsl:attribute>
                 <xsl:attribute name="xRelation">observation.sujet</xsl:attribute>
                 <xsl:attribute name="id_sujet"><xsl:value-of select="$lid"/></xsl:attribute>
                 <xsl:attribute name="id_observation"><xsl:value-of select="attribute[@NAME='id_observation']/@VALUE"/></xsl:attribute>
               </xsl:element>
           </xsl:when>
           <xsl:when test="$composition='expo'">       
                <xsl:element name="lier">
                 <xsl:attribute name="xObjet">observation</xsl:attribute>
                 <xsl:attribute name="xRelation">observation.expo</xsl:attribute>
                 <xsl:attribute name="id_article"><xsl:value-of select="$lid"/></xsl:attribute>
                 <xsl:attribute name="id_observation"><xsl:value-of select="attribute[@NAME='id_observation']/@VALUE"/></xsl:attribute>
               </xsl:element>
           </xsl:when>
         </xsl:choose>
       </xsl:if>
     </xsl:for-each>
   </xsl:template>
   
    
   <xsl:template match="node" mode="lienCampagne">
     <xsl:variable name="lid"><xsl:value-of select="../attribute[@NAME='id_campagne']/@VALUE"/></xsl:variable>
     <xsl:for-each select="node">
         <xsl:choose>
           <xsl:when test="@COLOR=$observation">       
                <xsl:element name="lier">
                 <xsl:attribute name="xObjet">observation</xsl:attribute>
                 <xsl:attribute name="xRelation">observation.campagne</xsl:attribute>
                 <xsl:attribute name="id_campagne"><xsl:value-of select="$lid"/></xsl:attribute>
                 <xsl:attribute name="id_observation"><xsl:value-of select="attribute[@NAME='id_observation']/@VALUE"/></xsl:attribute>
               </xsl:element>
           </xsl:when>
         </xsl:choose>
       </xsl:for-each>
   </xsl:template>
   
    <xsl:template match="node" mode="creerArticle">
      <xsl:param name="composition" />
         <xsl:if test="../@COLOR=$rubrique">
           <xsl:apply-templates select="node" mode="nouvelArticle">
             <xsl:with-param name="id_rubrique"><xsl:value-of select="../attribute[@NAME='id_rubrique']/@VALUE"/></xsl:with-param>
             <xsl:with-param name="composition"><xsl:value-of select="$composition"/></xsl:with-param>
           </xsl:apply-templates>
         </xsl:if>
   </xsl:template>  
   
   <xsl:template match="node" mode="nouvelArticle">
   	 <xsl:param name="id_rubrique" />
   	 <xsl:param name="composition" />
     <xsl:variable name="eTitre" select="normalize-space(substring-before(@TEXT,'/'))"/>
     <xsl:variable name="eSousTitre" select="normalize-space(substring-after(@TEXT,'/'))"/>
     
     	<xsl:element name="creer">
     	  <xsl:attribute name="xObjet"><xsl:value-of select="$composition"/></xsl:attribute>
     	  <xsl:attribute name="titre"><xsl:value-of select="$eTitre"/></xsl:attribute>
     	  <xsl:attribute name="soustitre"><xsl:value-of select="$eSousTitre"/></xsl:attribute>
     	  <xsl:attribute name="id_rubrique"><xsl:value-of select="$id_rubrique"/></xsl:attribute>
     	  <xsl:for-each select="node">
     	    <xsl:if test="@COLOR=$observation">
             <xsl:choose>
          	   <xsl:when test="$composition='espece'">
          		<xsl:element name="lier">
          			<xsl:attribute name="xObjet">observation</xsl:attribute>
          			<xsl:attribute name="xRelation">observation.espece</xsl:attribute>
          			<xsl:attribute name="id_espece">self</xsl:attribute>
          			<xsl:attribute name="id_observation"><xsl:value-of select="attribute[@NAME='id_observation']/@VALUE"/></xsl:attribute>
          		</xsl:element>
          	  </xsl:when>
          	  <xsl:when test="$composition='sujet'">
          		<xsl:element name="lier">
          			<xsl:attribute name="xObjet">observation</xsl:attribute>
          			<xsl:attribute name="xRelation">observation.sujet</xsl:attribute>
          			<xsl:attribute name="id_sujet">self</xsl:attribute>
          			<xsl:attribute name="id_observation"><xsl:value-of select="attribute[@NAME='id_observation']/@VALUE"/></xsl:attribute>
          		</xsl:element>
          	  </xsl:when>
          	  <xsl:when test="$composition='expo'">
          		<xsl:element name="lier">
          			<xsl:attribute name="xObjet">observation</xsl:attribute>
          			<xsl:attribute name="xRelation">observation.expo</xsl:attribute>
          			<xsl:attribute name="id_article">self</xsl:attribute>
          			<xsl:attribute name="id_observation"><xsl:value-of select="attribute[@NAME='id_observation']/@VALUE"/></xsl:attribute>
          		</xsl:element>
          	  </xsl:when>
          	 </xsl:choose>
          	</xsl:if>
          </xsl:for-each>
     	</xsl:element>
   </xsl:template>
   

   
  <xsl:template match="text()">
    <xsl:value-of select="."/>
  </xsl:template>
  
 </xsl:stylesheet>
