<?xml version="1.0" encoding="iso-8859-1"?>
<!--

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         ddi  la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2020 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a t dvelopp initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribu sous licence GNU/GPL.         *
 *  Pour plus de dtails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

  Document   : observations4spip.xsl
  Created on : 17 Feb 2017
  Author     : renaud.laurette
  Update     : 29 Aug 2020 - Gestion de plusieurs auteurs sur une observation
-->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	>
	
  <!-- Sortie avec caractres UTF -->
  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" standalone="yes"/>
  <xsl:param name="source" select="'9999'"/>
  
  <xsl:template match="/">
    <ordresBiodiv>
     <xsl:apply-templates select="/observations/observation" />
    </ordresBiodiv>
  </xsl:template>
 
  <xsl:template match="observation">
    <xsl:element name="creer">
      <xsl:attribute name="xObjet">observation</xsl:attribute>
      <xsl:attribute name="lat"><xsl:value-of select="lat"/></xsl:attribute>
      <xsl:attribute name="lng"><xsl:value-of select="lng"/></xsl:attribute>
      <xsl:attribute name="date"><xsl:value-of select="date_obs"/></xsl:attribute>
      <xsl:attribute name="espece"><xsl:value-of select="espece"/></xsl:attribute>
      <xsl:attribute name="binomial"><xsl:value-of select="binomial"/></xsl:attribute>
      <xsl:if test="pjour">
         <xsl:attribute name="pjour"><xsl:value-of select="pjour"/></xsl:attribute>
      </xsl:if>
      <xsl:attribute name="quantite"><xsl:value-of select="quantite"/></xsl:attribute>
      <xsl:if test="denombrement">
         <xsl:attribute name="denombrement"><xsl:value-of select="denombrement"/></xsl:attribute>
      </xsl:if>
      <xsl:attribute name="adresse"><xsl:value-of select="adresse"/></xsl:attribute>
      <xsl:attribute name="commune"><xsl:value-of select="commune"/></xsl:attribute>
      <xsl:attribute name="insee"><xsl:value-of select="insee"/></xsl:attribute>
      <xsl:attribute name="descriptif">
        <xsl:if test="id_auteur = 0">
          <!-- l'id_auteur doit tre 0 quand il n'est l'observateur pas inscritsur le site 
           Dans ce cas on indique son (leurs) nom(s) dans les commentaires.
           L'observation sera arbitrairement affecte  l'observateur 1 (webmestre) -->
          <xsl:text>Une observation de </xsl:text>
          <xsl:value-of select="observateurs"/>
          <xsl:text>. </xsl:text>
        </xsl:if>
      	<xsl:if test="string-length(notes)"><xsl:value-of select="notes"/><xsl:text> </xsl:text></xsl:if>
      	<xsl:if test="string-length(remarques)"><xsl:value-of select="remarques"/><xsl:text> </xsl:text></xsl:if>
      	<xsl:if test="string-length(milieu)"><xsl:value-of select="milieu"/><xsl:text> </xsl:text></xsl:if>
      </xsl:attribute>
      <xsl:attribute name="uTable">spip_biodiv_observations</xsl:attribute>
      <xsl:attribute name="uCondition">id_source=<xsl:value-of select="$source"/>,ref_source=<xsl:value-of select="xref"/></xsl:attribute>

      <xsl:if test="string-length(cd_nom)">
        <xsl:element name="lier">
          <xsl:attribute name="xObjet">observation</xsl:attribute>
          <xsl:attribute name="xRelation">observation.taxon</xsl:attribute>
          <xsl:attribute name="cd_nom"><xsl:value-of select="cd_nom"/></xsl:attribute>
          <xsl:attribute name="id_observation">self</xsl:attribute>
        </xsl:element>
      </xsl:if>	
      <!--<xsl:if test="/observations/@id_source">-->
        <xsl:element name="lier">
          <xsl:attribute name="xObjet">observation</xsl:attribute>
          <xsl:attribute name="xRelation">observation.source</xsl:attribute>
          <xsl:attribute name="ref_source"><xsl:value-of select="xref"/></xsl:attribute>
          <xsl:attribute name="id_source"><xsl:value-of select="$source"/></xsl:attribute>
          <xsl:attribute name="id_observation">self</xsl:attribute>
        </xsl:element>
      <!--</xsl:if>-->
      
      <!-- Les id_auteur sont lists dans une string, spars par des virgules 
      		On dcompose la string et on gnre un ordre par id_auteur -->
      <xsl:if test="string-length(id_auteur)">
        <!-- Au moins un auteur: on considre leur liste -->
      	<xsl:call-template name="splitAuteur">
    		<xsl:with-param name="pText" select="id_auteur"/>
    		<xsl:with-param name="pTop" select="'1'"/>
    	</xsl:call-template>
    	<!-- Et on demande le retrait de l'operateur s'il n'est pas dans les auteurs lists -->
    	<xsl:element name="lier">
    		<xsl:attribute name="xObjet">observation</xsl:attribute>
    		<xsl:attribute name="xRelation">observation.sans.operateur</xsl:attribute>
    		<xsl:attribute name="id_auteur"><xsl:value-of select="id_auteur"/></xsl:attribute>
    		<xsl:attribute name="id_observation">self</xsl:attribute>
    	</xsl:element>
      </xsl:if>	
      <!-- S'il n'y a aucun id_auteur, l'observation est attribue  l'oprateur -->

    </xsl:element>
  </xsl:template>
  
 <xsl:template match="text()" name="splitAuteur">
  <xsl:param name="pText" select="."/>
  <xsl:param name="pTop" select="'0'"/>
  <xsl:if test="string-length($pText) and ($pText != 0)">
    <xsl:element name="lier">
    	<xsl:attribute name="xObjet">observation</xsl:attribute>
    	<xsl:attribute name="xRelation">observation.auteur</xsl:attribute>
    	<xsl:attribute name="id_auteur"><xsl:value-of select="substring-before(concat($pText,','),',')"/></xsl:attribute>
    	<xsl:attribute name="id_observation">self</xsl:attribute>
    </xsl:element>
    <xsl:call-template name="splitAuteur">
    	<xsl:with-param name="pText" select="substring-after($pText, ',')"/>
    	<xsl:with-param name="pTop" select="'0'"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="($pTop=1) and ((string-length($pText)=0) or ($pText = 0))">
    <!-- Quand (id_auteur = 0) c'est que l'auteur n'est pas connu. 
    	On enregistre l'observation au nom du webmestre (id_auteur=1) 
    	et on indique le nom de l'auteur dans le champ commentaires.
    -->
    <xsl:element name="lier">
    	<xsl:attribute name="xObjet">observation</xsl:attribute>
    	<xsl:attribute name="xRelation">observation.auteur</xsl:attribute>
    	<xsl:attribute name="id_auteur">1</xsl:attribute>
    	<xsl:attribute name="id_observation">self</xsl:attribute>
    </xsl:element>
  </xsl:if>
 </xsl:template>

                                                 
  

  <!-- Tout le reste -->
  <xsl:template match="text()"/>
  
 </xsl:stylesheet>
 
