<?php
/**
 * Utilisations de pipelines par Rebond
 *
 * @plugin     Rebond
 * @copyright  2025
 * @author     Renaud LAURETTE
 * @licence    GNU/GPL
 * @package    SPIP\Rebond\Pipelines
 */

if (!defined('_ECRIRE_INC_VERSION')) {
	return;
}

include_spip('inc/utils');

/**
 * Correction de la description d'une resource document/rebond pour Jason
 *
 * Dans le cas d'un rebond, le fichier connu de SPIP ne contient pas la
 * donnée elle-même, mais uniquement des informations permettant d'accéder à la donnée.
 * On doit donc requalifier le lien 'preview' en lien 'describedby' et calculer
 * le vrai lien preview pour l'insérer dans la liste des liens.
 *
 */
 
function rebond_jason_get_ressource($flux) {
	
	// lecture
	$reponse = $flux['args']['reponse'];
	$data = $flux['data'];
	$item = $data['collection']['items'][0];	// Un seul item pour une ressource
	$links = $item['links'];
	$idata = $item['data'];
	
	// traitement
	if($item['collection'] == 'documents') { 	// Seuls les documents sont traités
		$id = intval($item['id']); 				// on récupère l'id_document et les champs 
		$champs = [];
		foreach($idata as $key => $record) {
			$champs[$record['name']] = $record['value'];
		}
		
		// On ne traite que les 'rebond'
		if(array_key_exists('extension',$champs) and ($champs['extension'] == 'rebond')) {
			$nlinks = [];
			foreach($links as $link) {
				
				if($link['rel'] == 'preview') {
					// On remplace le lien 'preview' par un lien 'describedby'
					// car la cible du lien ne donne pas accès à un preview de la resource
					// mais seulement aux données permettant d'accéder au preview
					$nlinks[] = array('rel'=> 'describedby', 'href' => $link['href']);
					
					// On récupère ensuite le contenu du fichier rebond pour construire 
					// le vrai chemin de preview
					$file = _DIR_IMG . $champs['fichier'];
					// on se prépare au pire ...
					$url = url_absolue(generer_url_public('404'));
					// ... mais on croise les doigts
					if(file_exists($file)) {
						$json = file_get_contents($file);
						$rebond = json_decode($json,true);	// décodage en tableau associatif
						if( array_key_exists('_type',$rebond) and
							array_key_exists('_ressource',$rebond) and
							array_key_exists('_clefs',$rebond)) {
						
							// En fonction du type de rebond, on détermine l'URL du preview
							switch($rebond['_ressource']) {
							case 'youtube-video':
								$url = 'https://www.youtube.com/watch?v='.$rebond['_clefs']['id'];
								break;
							case 'soundcloud-track':
								$url = 'https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/soundcloud%253Atracks%253A'.$rebond['_clefs']['id'].'&color=%23ff5500&auto_play=true&hide_related=false&show_comments=true&show_user=true&show_reposts=false&show_teaser=true&visual=true';
								break;
							case 'dailymotion-video':
								$url = 'https://geo.dailymotion.com/player.html?video='.$rebond['_clefs']['id'];
								break;
							default:	
								// l'url de la page 404 de spip sera appliquée
								break;
							}
						}
					}
					// dans tous les cas on crée un nouveau lien 
					$nlinks[] = array('rel'=> 'preview', 'href' => $url);
					
				} else {
					
					// On garde les autres types de liens
					$nlinks[] = $link;
				}
			}
			
			// On remplace les anciens liens par les nouveaux
			$data['collection']['items'][0]['links'] = $nlinks;
			
		} // Fin du traitement des rebonds
	} // Fin du traitement des documents
								
	// ecriture et retour
	
	$flux['data'] = $data;
	$reponse->setContent(json_encode($data));
	$flux['args']['reponse'] = $reponse;
	
	return $flux;
}
	
	