<?php

/*******************************************************************************\
 * SIBACTU, plugin et squelette pour SPIP - https://www.spip.net/              *
 *         ddi  la gestion de mails via Sendinblue (Brevo)                  *
 *                                                                             *
 *         Copyright (C) 2023 Renaud LAURETTE                                  *
 *                                                                             *
\*******************************************************************************/

/**
 * Lecture d'un fichier d'actualits
 *
 * @param string src - nom du fichier  lire
 * @param array tableaux - liste des champs tableau  trouver
 * @param array textes - liste des champs texte  trouver
 * @return array - le tableau des champs lus
 *
 * Un champ texte est obligatoire : 'sujet'
 */

function actualites($src,$textes,$tableaux) {
	
	/* initialisation */	
	foreach($textes as $key)
		$data[$key] = '';
	foreach($tableaux as $key)
		$data[$key] = array();
		
	/* lecture du fichier d'actualits */
	$file = _DIR_IMG . 'actualites/' . $src;
	$file2 = _DIR_TMP . 'actualites/' . $src;
	$contents = FALSE;
	
	// On cherche d'abord les donnes valides dans IMG
	// Si on ne trouve pas, on cherche les donnes non valides dans le rpertoire temporaire
	if(file_exists($file)) {		
		$contents = file_get_contents($file);
	} else {
		$contents = file_get_contents($file2);
	}
	if($contents === FALSE) {
		$data['sujet'] = _T('actu:pas_de_fichier');
		return $data;
	}
	
	/* dcodage */
	$actu = @unserialize($contents);
	if(!is_array($actu)) {
		$data['sujet'] = _T('actu:pb_format_fichier');
		return $data;
	}
	
	/* remplissage */
	foreach($textes as $key) {
		if(array_key_exists($key,$actu)) {
			$data[$key] = $actu[$key];
		}
	}
	foreach($tableaux as $key) {
		if(array_key_exists($key,$actu)) {
			$data[$key] = is_array($actu[$key]) ? $actu[$key] : array($actu[$key]);
		}
	}		
	
	/* on envoie */
	return $data;
}

?>
