<?php
/**
 * Utilisations de pipelines par Sibmail
 *
 * @plugin     Sibmail
 * @copyright  2023
 * @author     Renaud LAURETTE
 * @licence    GNU/GPL
 * @package    SPIP\Sibmail\Pipelines
 */

if (!defined('_ECRIRE_INC_VERSION')) {
	return;
}

include_spip('config/sibmail');

/**
 * Pipelines
 */
 
/* 
function sibmail_post_insertion($flux) {
	if($flux['args']['table'] == 'spip_auteurs') {
		$id_auteur = $flux['args']['id_objet'];  
		$activation = lire_config('sibmail/inscription_automatique');
		if($activation == 'on') {	
			spip_log("SIBMAIL::PostInsertion - tentative d'inscription de l'auteur $id_auteur","sibmail."._LOG_INFO_IMPORTANTE);
			sibmail_subscribe($id_auteur);
		} else {
			spip_log("SIBMAIL::PostInsertion - pas d'inscription automatique ($activation) de l'auteur $id_auteur","sibmail."._LOG_INFO_IMPORTANTE);
		}
	}
	return $flux;
}
*/

function sibmail_post_edition($flux) {
	if($flux['args']['table'] == 'spip_auteurs') {
		$id_auteur = $flux['args']['id_objet'];
		$activation = lire_config('sibmail/inscription_automatique');
		if($activation == 'on') {	
			spip_log("SIBMAIL::PostEdition - tentative d'inscription de l'auteur $id_auteur","sibmail."._LOG_INFO_IMPORTANTE);
			sibmail_subscribe($id_auteur);
		} else {
			spip_log("SIBMAIL::PostEdition - pas d'inscription automatique ($activation) de l'auteur $id_auteur","sibmail."._LOG_INFO_IMPORTANTE);
		}
	}
	return $flux;
}			
		

 /**
 * Taches périodiques
 *
 * Donne la périodicité des tâches en secondes.
 * La $tache['nom'] est décite par la fonction genie_nom_dist() dans le
 * fichier genie/nom.php
 * 
 * Scrutation du répertoire _SIMB_COLLECT qui reçoit les notification HelloAsso
 * lors des nouvelles adhésions. La tâche ne sera active que si le plugin est
 * configuré pour propager les adhérents.
 *
 * @pipeline taches_generales_cron
 * @param  array $taches tableau de tâches à exécuter
 * @return array      	 tableau de tâches à exécuter
**/
function sibmail_taches_generales_cron($taches){
	$actif = lire_config('sibmail/propager_adherents');	
	if($actif == 'on') {
		$repertoire = _SIBM_COLLECT;
		if((!is_dir($repertoire)) and (!file_exists($repertoire))) {
			mkdir($repertoire);
		}
		$taches['propager_adherents'] = _SIBM_FREQUENCE_ADHESION; 	// Traitement des entrées HelloAsso	
		// spip_log("SIBMAIL::CRON - taches enregitrées : " . print_r($taches,true), "sibmail."._LOG_INFO_IMPORTANTE);
	}
	return $taches;
}
