<?php

/**
 * Gestion du pipeline destiné à déplacer les lettres d'actualités
 * juste avant l'envoi vers Brevo (voir sibmail/formulaires/envoyer_lettre.php)
**/

function sibactu_avant_envoyer_lettre($params) {
	
	// On déplace le fichier contenant les données, s'il existe
	$avant = _DIR_TMP . 'actualites/' . $params[2]; // $ref
	$apres = _DIR_IMG . 'actualites/' . $params[2];
	if(is_file($avant)) rename($avant,$apres);
	
	// On retourne les paramètres sans les changer
	return $params;
}

/**
 * Pipeline des tâches périodiques
**/
 
define('_SIBA_FREQUENCE_AGENDA', 3600*6);	// Nb de secondes entre 2 traitements (cron)

function sibactu_taches_generales_cron($taches){
	
	// propagation des événements d'agenda
	$actif = lire_config('sibactu/propager_agenda');	
	if($actif == 'on') {
		$taches['propager_agenda'] = _SIBA_FREQUENCE_AGENDA;
	}
	
	return $taches;
}

?>
